/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.processor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;
import psidev.psi.mi.tab.utils.PsiCollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterInteractorPairProcessor<T extends BinaryInteraction>
implements PostProcessorStrategy<T> {
    public static final Log log = LogFactory.getLog(ClusterInteractorPairProcessor.class);

    protected void mergeCollection(Collection source, Collection target) {
        if (source == null) {
            throw new IllegalArgumentException("Source collection must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target collection must not be null.");
        }
        if (source == target) {
            throw new IllegalStateException();
        }
        for (Object o : source) {
            target.add(o);
        }
    }

    @Override
    public Collection<T> process(Collection<T> interactions) {
        boolean verbose = true;
        HashMap<TwoInteractor, BinaryInteraction> map = new HashMap<TwoInteractor, BinaryInteraction>(interactions.size());
        int count = 0;
        int global = 0;
        long start = System.currentTimeMillis();
        Iterator<T> iterator = interactions.iterator();
        while (iterator.hasNext()) {
            TwoInteractor ti;
            BinaryInteraction target;
            BinaryInteraction interaction = (BinaryInteraction)iterator.next();
            ++global;
            if (log.isDebugEnabled() && ++count != 0 && count % 1000 == 0) {
                float elapsedTimeMin = (float)(System.currentTimeMillis() - start) / 60000.0f;
                int nbRemainInteractions = interactions.size() - global;
                double timeByInteraction = (double)elapsedTimeMin / 1000.0;
                double etaMin = timeByInteraction * (double)nbRemainInteractions;
                log.debug((Object)(global + " interactions processed (" + elapsedTimeMin + " min for these last 1000) - ETA = " + etaMin + " min"));
                count = 0;
                start = System.currentTimeMillis();
            }
            if ((target = (BinaryInteraction)map.get(ti = new TwoInteractor(new SimpleInteractor((Interactor)interaction.getInteractorA()), new SimpleInteractor((Interactor)interaction.getInteractorB())))) != null) {
                if (target == interaction) {
                    log.warn((Object)("The given collection cluster contained twice the same interaction. one was removed: " + interaction));
                    iterator.remove();
                    continue;
                }
                this.mergeCollections(interaction, target);
                continue;
            }
            map.put(ti, interaction);
        }
        return map.values();
    }

    protected void mergeCollections(T interaction, T target) {
        this.mergeCollection(interaction.getAuthors(), target.getAuthors());
        this.mergeCollection(interaction.getPublications(), target.getPublications());
        this.mergeCollection(interaction.getConfidenceValues(), target.getConfidenceValues());
        this.mergeCollection(interaction.getDetectionMethods(), target.getDetectionMethods());
        this.mergeCollection(interaction.getInteractionTypes(), target.getInteractionTypes());
        this.mergeCollection(interaction.getSourceDatabases(), target.getSourceDatabases());
        this.mergeCollection(interaction.getInteractionAcs(), target.getInteractionAcs());
    }

    protected static class TwoInteractor {
        private SimpleInteractor interactorA;
        private SimpleInteractor interactorB;

        public TwoInteractor(SimpleInteractor interactorA, SimpleInteractor interactorB) {
            if (interactorA == null) {
                throw new IllegalArgumentException();
            }
            if (interactorB == null) {
                throw new IllegalArgumentException();
            }
            this.interactorA = interactorA;
            this.interactorB = interactorB;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TwoInteractor that = (TwoInteractor)o;
            return this.interactorA.equals(that.interactorA) && this.interactorB.equals(that.interactorB) || this.interactorA.equals(that.interactorB) && this.interactorB.equals(that.interactorA);
        }

        public int hashCode() {
            Collection inter = PsiCollectionUtils.intersection(this.interactorA.identifiers, this.interactorB.identifiers);
            int res = 1;
            for (CrossReferenceImpl reference : inter) {
                res = 31 * res * ((Object)reference).hashCode();
            }
            res *= this.interactorA.taxid != null ? this.interactorA.taxid.hashCode() : 1;
            return res *= this.interactorB.taxid != null ? this.interactorB.taxid.hashCode() : 1;
        }
    }

    protected static class SimpleInteractor {
        Collection<CrossReference> identifiers;
        Integer taxid;

        public SimpleInteractor(Interactor interactor) {
            if (interactor == null) {
                throw new IllegalArgumentException("Interactor should not be null.");
            }
            this.identifiers = interactor.getIdentifiers();
            if (interactor.hasOrganism()) {
                for (CrossReference cr : interactor.getOrganism().getIdentifiers()) {
                    if (!cr.getDatabase().equals("taxid")) continue;
                    this.taxid = new Integer(cr.getIdentifier());
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleInteractor that = (SimpleInteractor)o;
            if (this.taxid != null ? !this.taxid.equals(that.taxid) : that.taxid != null) {
                return false;
            }
            return !PsiCollectionUtils.intersection(this.identifiers, that.identifiers).isEmpty();
        }

        public int hashCode() {
            int result = ((Object)this.identifiers).hashCode();
            result = 31 * result + (this.taxid != null ? this.taxid.hashCode() : 0);
            return result;
        }
    }
}

