/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model.builder;

import psidev.psi.mi.tab.model.builder.AbstractFieldBuilder;
import psidev.psi.mi.tab.model.builder.Field;
import psidev.psi.mi.tab.model.builder.IllegalFormatException;
import psidev.psi.mi.tab.model.builder.ParseUtils;

public class CrossReferenceFieldBuilder
extends AbstractFieldBuilder {
    private static final String MI_PREFIX = "MI";

    public Field createField(String str) {
        String[] groups = ParseUtils.quoteAwareSplit(str = this.removeLineReturn(str), new char[]{':', '(', ')'}, true);
        if (groups.length == 0 || groups.length > 3) {
            throw new IllegalFormatException("String cannot be parsed to create a Field (check the syntax): " + str);
        }
        Field field = null;
        switch (groups.length) {
            case 1: {
                field = new Field(groups[0]);
                break;
            }
            case 2: {
                field = new Field(groups[0], groups[1]);
                break;
            }
            case 3: {
                field = new Field(groups[0], groups[1], groups[2]);
            }
        }
        if (field != null && field.getDescription() == null && field.getType() == null && String.valueOf('-').equals(field.getValue())) {
            field = null;
        }
        if (field != null) {
            field = this.fixPsimiFieldfNecessary(field);
        }
        return field;
    }

    protected Field fixPsimiFieldfNecessary(Field field) {
        if (MI_PREFIX.equals(field.getType())) {
            String identifier = field.getValue();
            return new Field("psi-mi", "MI:" + identifier, field.getDescription());
        }
        return field;
    }
}

