/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.model;

import java.util.ArrayList;
import java.util.List;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.Interactor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinaryInteraction<T extends Interactor>
implements BinaryInteraction<T> {
    private T interactorA;
    private T interactorB;
    private List<InteractionDetectionMethod> detectionMethods;
    private List<InteractionType> interactionTypes;
    private List<CrossReference> publications;
    private List<Confidence> confidenceValues;
    private List<CrossReference> sourceDatabases;
    private List<CrossReference> interactionAcs;
    private List<Author> authors;
    private static int expectedColumnCount = 15;

    public AbstractBinaryInteraction(T interactorA, T interactorB) {
        this.setInteractorA(interactorA);
        this.setInteractorB(interactorB);
    }

    @Override
    public void flip() {
        T interactorA = this.getInteractorA();
        T interactorB = this.getInteractorB();
        this.setInteractorA(interactorB);
        this.setInteractorB(interactorA);
    }

    @Override
    public T getInteractorA() {
        return this.interactorA;
    }

    @Override
    public void setInteractorA(T interactorA) {
        if (interactorA == null) {
            throw new IllegalArgumentException("You must give a non null interactor A.");
        }
        this.interactorA = interactorA;
    }

    @Override
    public T getInteractorB() {
        return this.interactorB;
    }

    @Override
    public void setInteractorB(T interactorB) {
        if (interactorB == null) {
            throw new IllegalArgumentException("You must give a non null interactor B.");
        }
        this.interactorB = interactorB;
    }

    @Override
    public List<InteractionDetectionMethod> getDetectionMethods() {
        if (this.detectionMethods == null) {
            this.detectionMethods = new ArrayList<InteractionDetectionMethod>(2);
        }
        return this.detectionMethods;
    }

    @Override
    public void setDetectionMethods(List<InteractionDetectionMethod> detectionMethods) {
        this.detectionMethods = detectionMethods;
    }

    @Override
    public List<InteractionType> getInteractionTypes() {
        if (this.interactionTypes == null) {
            this.interactionTypes = new ArrayList<InteractionType>(2);
        }
        return this.interactionTypes;
    }

    @Override
    public void setInteractionTypes(List<InteractionType> interactionTypes) {
        this.interactionTypes = interactionTypes;
    }

    @Override
    public List<CrossReference> getPublications() {
        if (this.publications == null) {
            this.publications = new ArrayList<CrossReference>(2);
        }
        return this.publications;
    }

    @Override
    public void setPublications(List<CrossReference> publications) {
        this.publications = publications;
    }

    @Override
    public List<Confidence> getConfidenceValues() {
        if (this.confidenceValues == null) {
            this.confidenceValues = new ArrayList<Confidence>(2);
        }
        return this.confidenceValues;
    }

    @Override
    public void setConfidenceValues(List<Confidence> confidenceValues) {
        this.confidenceValues = confidenceValues;
    }

    @Override
    public List<Author> getAuthors() {
        if (this.authors == null) {
            this.authors = new ArrayList<Author>(2);
        }
        return this.authors;
    }

    @Override
    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    @Override
    public List<CrossReference> getSourceDatabases() {
        if (this.sourceDatabases == null) {
            this.sourceDatabases = new ArrayList<CrossReference>(2);
        }
        return this.sourceDatabases;
    }

    @Override
    public void setSourceDatabases(List<CrossReference> sourceDatabases) {
        this.sourceDatabases = sourceDatabases;
    }

    @Override
    public List<CrossReference> getInteractionAcs() {
        if (this.interactionAcs == null) {
            this.interactionAcs = new ArrayList<CrossReference>(2);
        }
        return this.interactionAcs;
    }

    @Override
    public void setInteractionAcs(List<CrossReference> interactionAcs) {
        this.interactionAcs = interactionAcs;
    }

    @Override
    public int getExpectedColumnCount() {
        return expectedColumnCount;
    }

    public void setExpectedColumnCount(int expectedColumnCount) {
        AbstractBinaryInteraction.expectedColumnCount = expectedColumnCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{interactorA=").append(this.interactorA);
        sb.append(", interactorB=").append(this.interactorB);
        sb.append(", detectionMethods=").append(this.detectionMethods);
        sb.append(", interactionTypes=").append(this.interactionTypes);
        sb.append(", publications=").append(this.publications);
        sb.append(", confidenceValues=").append(this.confidenceValues);
        sb.append(", sourceDatabases=").append(this.sourceDatabases);
        sb.append(", interactionAcs=").append(this.interactionAcs);
        sb.append(", authors=").append(this.authors);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        boolean part2;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBinaryInteraction that = (AbstractBinaryInteraction)o;
        if (this.detectionMethods != null ? !((Object)this.detectionMethods).equals(that.detectionMethods) : that.detectionMethods != null) {
            return false;
        }
        if (this.interactionTypes != null ? !((Object)this.interactionTypes).equals(that.interactionTypes) : that.interactionTypes != null) {
            return false;
        }
        boolean part1 = ((Interactor)this.interactorA).equals(that.interactorA) && ((Interactor)this.interactorB).equals(that.interactorB);
        boolean bl = part2 = ((Interactor)this.interactorB).equals(that.interactorA) && ((Interactor)this.interactorA).equals(that.interactorB);
        if (!part1 && !part2) {
            return false;
        }
        return !(this.publications != null ? !((Object)this.publications).equals(that.publications) : that.publications != null);
    }

    public int hashCode() {
        int result = ((Interactor)this.interactorA).hashCode() * ((Interactor)this.interactorB).hashCode();
        result = 31 * result + (this.detectionMethods != null ? ((Object)this.detectionMethods).hashCode() : 0);
        result = 31 * result + (this.interactionTypes != null ? ((Object)this.interactionTypes).hashCode() : 0);
        result = 31 * result + (this.publications != null ? ((Object)this.publications).hashCode() : 0);
        return result;
    }
}

