/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.xml2tab.InteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.MitabInteractionConverter;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.directoryProcessor.InputDirectoryProcessorStrategy;
import psidev.psi.mi.tab.directoryProcessor.PatternBasedFilenameSelection;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceFactory;
import psidev.psi.mi.tab.processor.PostProcessorStrategy;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2Tab {
    public static final Log log = LogFactory.getLog(Xml2Tab.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";
    private static final Pattern XML_EXTENSION = Pattern.compile(".*\\.xml");
    public static final InputDirectoryProcessorStrategy DEFAULT_DIRECTORY_PROCESSOR = new PatternBasedFilenameSelection(true, XML_EXTENSION);
    private PostProcessorStrategy postProcessor;
    private ExpansionStrategy expansionStrategy;
    private InputDirectoryProcessorStrategy directoryProcessorStrategy = DEFAULT_DIRECTORY_PROCESSOR;
    private Set<CrossReference> overrideSourceDatabases;
    private CrossReference overrideAliasSourceDatabase;
    private InteractionConverter<?> interactionConverter;

    public Xml2Tab() {
        this(new MitabInteractionConverter(), null);
    }

    public Xml2Tab(InteractionConverter<?> interactionConverter) {
        this(interactionConverter, null);
    }

    public Xml2Tab(InteractionConverter<?> interactionConverter, PostProcessorStrategy postProcessorStrategy) {
        this.interactionConverter = interactionConverter;
        this.postProcessor = postProcessorStrategy;
    }

    public PostProcessorStrategy getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessorStrategy postProcessor) {
        this.postProcessor = postProcessor;
    }

    public ExpansionStrategy getExpansionStrategy() {
        return this.expansionStrategy;
    }

    public void setExpansionStrategy(ExpansionStrategy expansionStrategy) {
        this.expansionStrategy = expansionStrategy;
    }

    public InputDirectoryProcessorStrategy getDirectoryProcessorStrategy() {
        return this.directoryProcessorStrategy;
    }

    public void setDirectoryProcessorStrategy(InputDirectoryProcessorStrategy directoryProcessorStrategy) {
        this.directoryProcessorStrategy = directoryProcessorStrategy;
    }

    public Collection<CrossReference> getOverrideSourceDatabase() {
        if (this.overrideSourceDatabases == null) {
            this.overrideSourceDatabases = new HashSet<CrossReference>();
        }
        return this.overrideSourceDatabases;
    }

    public void addOverrideSourceDatabase(CrossReference overrideSourceDatabase) {
        if (this.overrideSourceDatabases == null) {
            this.overrideSourceDatabases = new HashSet<CrossReference>();
        }
        this.overrideSourceDatabases.add(overrideSourceDatabase);
    }

    public Collection<CrossReference> getOverrideSourceDatabases() {
        return this.overrideSourceDatabases;
    }

    public CrossReference getOverrideAliasSourceDatabase() {
        return this.overrideAliasSourceDatabase;
    }

    public void setOverrideAliasSourceDatabase(CrossReference overrideAliasSourceDatabase) {
        this.overrideAliasSourceDatabase = overrideAliasSourceDatabase;
    }

    public void setOverrideSourceDatabases(Collection<CrossReference> overrideSourceDatabases) {
        this.overrideSourceDatabases = new HashSet<CrossReference>(overrideSourceDatabases);
    }

    public Collection<BinaryInteraction> convert(File file) throws TabConversionException {
        return this.convert(file, false);
    }

    public Collection<BinaryInteraction> convert(File file, boolean skipPostProcessing) throws TabConversionException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        Collection<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>();
        File f2 = null;
        try {
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converting directory: " + file.getAbsolutePath()));
                }
                Collection<File> files = null;
                files = this.directoryProcessorStrategy == null ? DEFAULT_DIRECTORY_PROCESSOR.process(file) : this.directoryProcessorStrategy.process(file);
                for (File f2 : files) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Converting file: " + f2.getAbsolutePath()));
                    }
                    PsimiXmlReader reader = new PsimiXmlReader();
                    EntrySet entrySet = reader.read(f2);
                    interactions.addAll(this.convert(entrySet, true));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Converting file: " + file));
                }
                PsimiXmlReader reader = new PsimiXmlReader();
                EntrySet entrySet = reader.read(file);
                interactions.addAll(this.convert(entrySet, true));
            }
        }
        catch (Exception e) {
            throw new TabConversionException("An error occured during PSIMITAB conversion of " + (f2 == null ? file.getAbsolutePath() : f2.getAbsolutePath()), e);
        }
        if (!skipPostProcessing) {
            interactions = this.doPostProcessing(interactions);
        }
        return interactions;
    }

    public Collection<BinaryInteraction> convert(Collection<File> inputFiles) throws TabConversionException {
        return this.convert(inputFiles, false);
    }

    public Collection<BinaryInteraction> convert(Collection<File> inputFiles, boolean skipPostProcessing) throws TabConversionException {
        Collection<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>(128);
        for (File file : inputFiles) {
            interactions.addAll(this.convert(file));
        }
        if (!skipPostProcessing) {
            interactions = this.doPostProcessing(interactions);
        }
        return interactions;
    }

    public Collection<BinaryInteraction> convert(EntrySet entrySet) throws TabConversionException {
        return this.convert(entrySet, false);
    }

    public Collection<BinaryInteraction> convert(EntrySet entrySet, boolean skipPostProcessing) throws TabConversionException {
        if (entrySet == null) {
            throw new IllegalArgumentException("You must give a non null entrySet.");
        }
        Collection<BinaryInteraction> interactions = new ArrayList<BinaryInteraction>();
        this.interactionConverter.setOverrideAliasSourceDatabase(this.overrideAliasSourceDatabase);
        for (Entry entry : entrySet.getEntries()) {
            String sourceName = null;
            String sourceId = null;
            if (this.overrideSourceDatabases == null) {
                if (entry.hasSource()) {
                    Names names;
                    Source source = entry.getSource();
                    if (source.hasNames() && (names = source.getNames()).getShortLabel() != null) {
                        sourceName = names.getShortLabel();
                    }
                    if (source.hasXref()) {
                        DbReference ref;
                        Xref xref = source.getXref();
                        Collection<DbReference> refs = XrefUtils.searchByType(xref, "primary-reference", "MI:0358");
                        Iterator<DbReference> dbReferenceIterator = refs.iterator();
                        while (dbReferenceIterator.hasNext()) {
                            DbReference dbReference = dbReferenceIterator.next();
                            if (dbReference.getDbAc().equals(PSI_MI_REF)) continue;
                            dbReferenceIterator.remove();
                        }
                        if (refs.size() == 1 && (ref = refs.iterator().next()).getId() != null) {
                            sourceId = ref.getId();
                        }
                    }
                    if (sourceId != null) {
                        String[] values = sourceId.split(":");
                        String db = values[0];
                        String id = values[1];
                        this.interactionConverter.addSourceDatabase(CrossReferenceFactory.getInstance().build(db, id, sourceName));
                    } else {
                        this.interactionConverter.addSourceDatabase(CrossReferenceFactory.getInstance().build("unknown", sourceName, sourceName));
                    }
                }
            } else {
                for (CrossReference sd : this.overrideSourceDatabases) {
                    this.interactionConverter.addSourceDatabase(sd);
                    log.info((Object)("Add Overriding source database: " + sd));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Interaction count: " + entry.getInteractions().size()));
            }
            for (Interaction interaction : entry.getInteractions()) {
                if (this.expansionStrategy != null && interaction.getParticipants().size() != 2) {
                    Collection<Interaction> expandedInteractions = this.expansionStrategy.expand(interaction);
                    for (Interaction exi : expandedInteractions) {
                        BinaryInteraction binaryInteraction = this.interactionConverter.toMitab(exi);
                        this.processAfterConversion(binaryInteraction, true);
                        if (binaryInteraction == null) continue;
                        interactions.add(binaryInteraction);
                    }
                    continue;
                }
                BinaryInteraction binaryInteraction = this.interactionConverter.toMitab(interaction);
                this.processAfterConversion(binaryInteraction, false);
                if (binaryInteraction == null) continue;
                interactions.add(binaryInteraction);
            }
        }
        if (!skipPostProcessing) {
            interactions = this.doPostProcessing(interactions);
        }
        return interactions;
    }

    protected void processAfterConversion(BinaryInteraction binaryInteraction, boolean expanded) {
    }

    private Collection<BinaryInteraction> doPostProcessing(Collection<BinaryInteraction> interactions) {
        if (interactions == null) {
            throw new IllegalArgumentException("Interaction cannot be null.");
        }
        Collection<BinaryInteraction> processedInteraction = null;
        if (this.postProcessor != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running " + this.postProcessor.getClass().getSimpleName() + "..."));
            }
            processedInteraction = this.postProcessor.process(interactions);
            log.debug((Object)"Post processing completed.");
        } else {
            log.debug((Object)"No post processing requested.");
            processedInteraction = interactions;
        }
        return processedInteraction;
    }

    public EntrySet convert(Collection<BinaryInteraction> interactions) {
        throw new UnsupportedOperationException();
    }
}

