/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.IdentifierGenerator;
import psidev.psi.mi.tab.converter.tab2xml.InteractorNameBuilder;
import psidev.psi.mi.tab.converter.tab2xml.InteractorUniprotIdBuilder;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.AliasUtils;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.AliasImpl;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceFactory;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.Organism;
import psidev.psi.mi.tab.model.OrganismFactory;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractorConverter<T extends Interactor> {
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    public static final String SOURCE_REFERENCE = "source reference";
    public static final String SOURCE_REFERENCE_REF = "MI:0685";
    public static final String UNIPROT = "uniprotkb";
    private static final String UNIPROT_MI = "MI:0486";
    public static final String INTACT = "intact";
    private static final String INTACT_MI = "MI:0469";
    public static final String CHEBI = "chebi";
    private static final String CHEBI_MI = "MI:0474";
    private static final String PSIMI = "psi-mi";
    private static final String PSIMI_MI = "MI:0488";
    private static final String UNKNWON = "unknown";
    private static final List<String> uniprotKeys = new ArrayList<String>(Arrays.asList("gene name", "gene name synonym", "isoform synonym", "ordered locus name", "open reading frame name"));
    public static final String SHORT_LABEL = "shortLabel";
    @Deprecated
    private CrossReference overrideAliasSourceDatabase;
    public static final Log log = LogFactory.getLog(InteractorConverter.class);
    private InteractorNameBuilder interactorNameBuilder;

    @Deprecated
    public void setOverrideAliasSourceDatabase(CrossReference overrideAliasSourceDatabase) {
        this.overrideAliasSourceDatabase = overrideAliasSourceDatabase;
    }

    private CrossReference buildCrossReference(DbReference ref) {
        return CrossReferenceFactory.getInstance().build(ref.getDb(), ref.getId());
    }

    public Interactor toMitab(psidev.psi.mi.xml.model.Interactor interactor) throws TabConversionException {
        if (interactor == null) {
            throw new IllegalArgumentException("Interactor must not be null");
        }
        ArrayList<CrossReference> identifiers = new ArrayList<CrossReference>(2);
        ArrayList<CrossReference> altIdentifiers = new ArrayList<CrossReference>(2);
        Collection<DbReference> identityRefs = null;
        if (interactor.getXref() != null) {
            identityRefs = XrefUtils.searchByType(interactor.getXref(), IDENTITY, IDENTITY_REF);
            for (DbReference ref : identityRefs) {
                CrossReference cr = this.buildCrossReference(ref);
                if (identifiers.contains(cr)) continue;
                identifiers.add(cr);
            }
            List<DbReference> allRefs = XrefUtils.getAllDbReferences(interactor.getXref());
            if (identifiers.isEmpty() && allRefs.size() > 0) {
                allRefs = XrefUtils.sortByIdentifier(allRefs);
                identifiers.add(this.buildCrossReference(allRefs.iterator().next()));
            }
        }
        if (identifiers.isEmpty()) {
            throw new TabConversionException("Could not find any identifiers for interactor " + interactor.getId());
        }
        T tabInteractor = this.newInteractor(identifiers);
        Collection<Alias> aliases = AliasUtils.getAllAliases(interactor.getNames());
        Alias gn = AliasUtils.getGeneName(aliases);
        if (gn != null) {
            aliases.remove(gn);
            String geneNameValue = gn.getValue();
            if (geneNameValue != null && geneNameValue.trim().length() > 0) {
                CrossReference cr = CrossReferenceFactory.getInstance().build(UNIPROT, geneNameValue);
                cr.setText(gn.getType());
                altIdentifiers.add(cr);
                ((Interactor)tabInteractor).setAlternativeIdentifiers(altIdentifiers);
            } else {
                log.warn((Object)"Found alias (gene name) without value. Ignoring");
            }
        }
        ArrayList<psidev.psi.mi.tab.model.Alias> tabAliases = new ArrayList<psidev.psi.mi.tab.model.Alias>();
        for (Alias alias : aliases) {
            String aliasValue = alias.getValue();
            if (aliasValue != null && aliasValue.trim().length() > 0) {
                String db = uniprotKeys.contains(alias.getType()) ? UNIPROT : UNKNWON;
                AliasImpl a = new AliasImpl(db, aliasValue);
                a.setAliasType(alias.getType());
                tabAliases.add(a);
                continue;
            }
            log.warn((Object)"Found alias without value. Ignoring alias");
        }
        if (interactor.getNames() != null && interactor.getNames().getShortLabel() != null) {
            String shortLabel = interactor.getNames().getShortLabel();
            String db = UNKNWON;
            AliasImpl a = new AliasImpl(db, shortLabel);
            a.setAliasType(SHORT_LABEL);
            tabAliases.add(a);
        }
        ((Interactor)tabInteractor).setAliases(tabAliases);
        if (interactor.hasOrganism()) {
            psidev.psi.mi.xml.model.Organism o = interactor.getOrganism();
            Organism organism = null;
            String name = null;
            if (o.hasNames() && o.getNames().hasShortLabel()) {
                name = o.getNames().getShortLabel();
            }
            organism = name == null ? OrganismFactory.getInstance().build(o.getNcbiTaxId()) : OrganismFactory.getInstance().build(o.getNcbiTaxId(), name);
            ((Interactor)tabInteractor).setOrganism(organism);
        }
        return tabInteractor;
    }

    protected T newInteractor(List<CrossReference> identifiers) {
        return (T)new Interactor(identifiers);
    }

    public InteractorNameBuilder getInteractorNameBuilder() {
        return this.interactorNameBuilder;
    }

    public void setInteractorNameBuilder(InteractorNameBuilder interactorNameBuilder) {
        this.interactorNameBuilder = interactorNameBuilder;
    }

    public psidev.psi.mi.xml.model.Interactor fromMitab(Interactor tabInteractor) throws XmlConversionException {
        if (tabInteractor == null) {
            throw new IllegalArgumentException("Interactor must not be null");
        }
        psidev.psi.mi.xml.model.Interactor xmlInteractor = new psidev.psi.mi.xml.model.Interactor();
        xmlInteractor.setId(IdentifierGenerator.getInstance().nextId());
        if (tabInteractor.hasOrganism()) {
            CrossReference first;
            Organism o = tabInteractor.getOrganism();
            Iterator<CrossReference> idIterator = o.getIdentifiers().iterator();
            String shortlabel = null;
            if (idIterator.hasNext() && (first = idIterator.next()).hasText()) {
                shortlabel = first.getText();
            }
            int ncbiTaxId = 0;
            if (o.getTaxid() != null) {
                try {
                    ncbiTaxId = Integer.parseInt(o.getTaxid());
                }
                catch (NumberFormatException e) {
                    String msg = "Could not parse taxid " + o.getTaxid() + ", it doesn't seem to be a valid integer value.";
                    throw new XmlConversionException(msg);
                }
                psidev.psi.mi.xml.model.Organism organism = new psidev.psi.mi.xml.model.Organism();
                Names names = new Names();
                organism.setNames(names);
                if (shortlabel != null) {
                    names.setShortLabel(shortlabel);
                } else {
                    names.setShortLabel(String.valueOf(ncbiTaxId));
                }
                organism.setNcbiTaxId(ncbiTaxId);
                xmlInteractor.setOrganism(organism);
            }
        }
        DbReference primaryReferece = null;
        ArrayList<DbReference> secondaryRefs = new ArrayList<DbReference>();
        Collection<CrossReference> tabIdentifiers = tabInteractor.getIdentifiers();
        String primaryDatabase = null;
        String primaryId = null;
        if (!tabIdentifiers.isEmpty()) {
            CrossReference primaryIdentifier;
            Iterator<CrossReference> identifierIterator = tabIdentifiers.iterator();
            this.overrideAliasSourceDatabase = primaryIdentifier = identifierIterator.next();
            primaryDatabase = primaryIdentifier.getDatabase();
            primaryId = primaryIdentifier.getIdentifier();
            primaryReferece = new DbReference(primaryId, primaryDatabase);
            if (primaryDatabase.equals(UNIPROT)) {
                primaryReferece.setDbAc(UNIPROT_MI);
                primaryReferece.setRefType(IDENTITY);
                primaryReferece.setRefTypeAc(IDENTITY_REF);
            } else if (primaryDatabase.equals(CHEBI)) {
                primaryReferece.setDbAc(CHEBI_MI);
                primaryReferece.setRefType(IDENTITY);
                primaryReferece.setRefTypeAc(IDENTITY_REF);
            } else if (primaryDatabase.equals(INTACT)) {
                primaryReferece.setDbAc(INTACT_MI);
                primaryReferece.setRefType(IDENTITY);
                primaryReferece.setRefTypeAc(IDENTITY_REF);
            }
            while (identifierIterator.hasNext()) {
                CrossReference secondaryIdentifier = identifierIterator.next();
                DbReference secondaryRef = this.createSecondaryRef(secondaryIdentifier);
                secondaryRefs.add(secondaryRef);
            }
        }
        if (primaryReferece != null) {
            Xref interactorXref;
            if (!secondaryRefs.isEmpty()) {
                interactorXref = new Xref(primaryReferece, secondaryRefs);
                xmlInteractor.setXref(interactorXref);
            } else {
                interactorXref = new Xref(primaryReferece);
                xmlInteractor.setXref(interactorXref);
            }
        } else {
            throw new XmlConversionException("No Xref found");
        }
        Names interactorName = null;
        if (this.interactorNameBuilder != null) {
            interactorName = this.interactorNameBuilder.select(tabInteractor);
        } else {
            log.debug((Object)("No InteractorNameBuilder choosen. default = " + InteractorUniprotIdBuilder.class));
            InteractorUniprotIdBuilder builder = new InteractorUniprotIdBuilder();
            interactorName = builder.select(tabInteractor);
        }
        if (interactorName != null) {
            xmlInteractor.setNames(interactorName);
        }
        InteractorType interactorType = new InteractorType();
        Xref interactorTypeXref = null;
        Names interactorTypeName = new Names();
        if (xmlInteractor.hasXref()) {
            String xrefPrimaryDB = xmlInteractor.getXref().getPrimaryRef().getDb();
            if (xrefPrimaryDB.equals(UNIPROT)) {
                interactorTypeName.setShortLabel("protein");
                interactorTypeName.setFullName("protein");
                DbReference dbRef = new DbReference("MI:0326", PSIMI);
                dbRef.setDbAc(PSIMI_MI);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
                interactorTypeXref = new Xref(dbRef);
            } else if (xrefPrimaryDB.equals(CHEBI)) {
                interactorTypeName.setShortLabel("small molecule");
                interactorTypeName.setFullName("small molecule");
                DbReference dbRef = new DbReference("MI:0328", PSIMI);
                dbRef.setDbAc(PSIMI_MI);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
                interactorTypeXref = new Xref(dbRef);
            } else {
                interactorTypeName.setShortLabel("unknown participant");
                interactorTypeName.setFullName("unknown participant");
                DbReference dbRef = new DbReference("MI:0329", PSIMI);
                dbRef.setDbAc(PSIMI_MI);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
                interactorTypeXref = new Xref(dbRef);
                log.debug((Object)"Interactor type is unknown");
            }
        }
        interactorType.setNames(interactorTypeName);
        interactorType.setXref(interactorTypeXref);
        xmlInteractor.setInteractorType(interactorType);
        return xmlInteractor;
    }

    private DbReference createSecondaryRef(CrossReference secondaryIdentifier) {
        String database = secondaryIdentifier.getDatabase();
        String id = secondaryIdentifier.getIdentifier();
        return new DbReference(id, database);
    }

    public abstract Participant buildParticipantA(psidev.psi.mi.xml.model.Interactor var1, BinaryInteraction var2, int var3) throws XmlConversionException;

    public abstract Participant buildParticipantB(psidev.psi.mi.xml.model.Interactor var1, BinaryInteraction var2, int var3) throws XmlConversionException;
}

