/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionDetectionMethodFactory;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionDetectionMethodConverter {
    public static final Log log = LogFactory.getLog(InteractionDetectionMethodConverter.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";

    public InteractionDetectionMethod toMitab(CvType cv) throws TabConversionException {
        Collection<DbReference> refs;
        Object myCv = null;
        if (cv == null) {
            throw new IllegalArgumentException("You must give a non null JAXB OpenCvType.");
        }
        String name = null;
        String db = "unknown";
        String id = null;
        if (cv.hasNames()) {
            name = cv.getNames().getShortLabel();
        }
        if ((refs = XrefUtils.searchByDatabase(cv.getXref(), PSI_MI, PSI_MI_REF)).isEmpty()) {
            refs = XrefUtils.searchByType(cv.getXref(), "identity", "MI:0356");
        }
        if (!refs.isEmpty()) {
            db = PSI_MI;
            Iterator<DbReference> iterator = refs.iterator();
            id = iterator.next().getId();
            if (iterator.hasNext()) {
                log.warn((Object)(cv + " has " + refs.size() + " references to PSI-MI to choose from, picked the first one."));
                log.warn((Object)("1: " + id));
                int i = 1;
                while (iterator.hasNext()) {
                    DbReference dbReference = iterator.next();
                    log.warn((Object)(++i + ": " + dbReference.getId()));
                }
            }
        }
        if (id == null) {
            throw new NullPointerException("Invalid interaction detection method without identifier: " + name);
        }
        return InteractionDetectionMethodFactory.getInstance().build(db, id, name);
    }

    public <T extends CvType> T fromMitab(InteractionDetectionMethod tabCv, Class<T> clazz) throws XmlConversionException {
        CvType myCv = null;
        if (tabCv == null) {
            throw new IllegalArgumentException("You must give a non null tabCv InteractionDetectionMethod.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("You must give a non null clazz Class.");
        }
        Names names = null;
        Xref xref = null;
        if (tabCv.hasText() && names == null) {
            String shortLabel = tabCv.getText();
            names = new Names();
            names.setShortLabel(shortLabel);
            names.setFullName(shortLabel);
        }
        if (tabCv.getIdentifier() != null && xref == null) {
            String primaryId = tabCv.getIdentifier();
            DbReference primaryRef = new DbReference();
            primaryRef.setId(primaryId);
            primaryRef.setRefType("identity");
            primaryRef.setRefTypeAc("MI:0356");
            primaryRef.setDb(PSI_MI);
            primaryRef.setDbAc(PSI_MI_REF);
            xref = new Xref(primaryRef);
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            myCv = (CvType)constructor.newInstance(new Object[0]);
            if (names != null) {
                myCv.setNames(names);
            }
            if (xref != null) {
                myCv.setXref(xref);
            }
        }
        catch (Exception e) {
            throw new XmlConversionException("An exception was thrown while instanciating an xml.", e);
        }
        return (T)myCv;
    }
}

