/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.XrefUtils;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceFactory;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReferenceConverter {
    public static final Log log = LogFactory.getLog(CrossReferenceConverter.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";

    public CrossReference toMitab(CvType cv) throws TabConversionException {
        Collection<DbReference> refs;
        CrossReference myCv = null;
        if (cv == null) {
            throw new IllegalArgumentException("You must give a non null JAXB OpenCvType.");
        }
        String name = null;
        String db = null;
        String id = null;
        if (cv.hasNames()) {
            name = cv.getNames().getShortLabel();
        }
        if (!(refs = XrefUtils.searchByDatabase(cv.getXref(), PSI_MI, PSI_MI_REF)).isEmpty()) {
            Iterator<DbReference> iterator = refs.iterator();
            DbReference dbRef = iterator.next();
            id = dbRef.getId();
            db = dbRef.getDb();
            if (iterator.hasNext()) {
                log.warn((Object)(cv + " has " + refs.size() + " references to PSI-MI to choose from, picked the first one."));
                boolean i = true;
                while (iterator.hasNext()) {
                    DbReference dbReference = iterator.next();
                }
            }
        }
        if (name != null) {
            CrossReferenceFactory.getInstance().build(db, id, name);
        }
        return myCv;
    }

    public <T extends CvType> T fromMitab(CrossReference tabCv, Class<T> clazz) throws XmlConversionException {
        CvType myCv = null;
        if (tabCv == null) {
            throw new IllegalArgumentException("You must give a non null tabCv CrossReference.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("You must give a non null clazz Class.");
        }
        Names names = null;
        Xref xref = null;
        if (tabCv.hasText()) {
            String shortLabel = tabCv.getText();
            names = new Names();
            names.setShortLabel(shortLabel);
            names.setFullName(shortLabel);
        }
        if (tabCv.getIdentifier() != null) {
            String id = tabCv.getIdentifier();
            DbReference primaryRef = new DbReference(id, PSI_MI);
            primaryRef.setDbAc(PSI_MI_REF);
            primaryRef.setRefType("identity");
            primaryRef.setRefTypeAc("MI:0356");
            xref = new Xref(primaryRef);
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            myCv = (CvType)constructor.newInstance(new Object[0]);
            if (names != null) {
                myCv.setNames(names);
            }
            if (xref != null) {
                myCv.setXref(xref);
            }
        }
        catch (Exception e) {
            throw new XmlConversionException("An exception was thrown while instanciating an xml.", e);
        }
        return (T)myCv;
    }
}

