/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view.tools;

import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.cytoscape.browser.internal.view.tools.AbstractToolBarControl;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;

public class GeneralOptionsControl
extends AbstractToolBarControl {
    private JCheckBox showTableGridCheck;
    private JCheckBox altRowColorsCheck;
    private final Class<? extends CyIdentifiable> objType;

    public GeneralOptionsControl(CyServiceRegistrar serviceRegistrar) {
        this((Class<? extends CyIdentifiable>)null, serviceRegistrar);
    }

    public GeneralOptionsControl(Class<? extends CyIdentifiable> objType, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.objType = objType;
        this.init();
    }

    @Override
    protected void update() {
        CyTableView tableView = this.getTableView();
        if (tableView != null) {
            Boolean showGrid = (Boolean)tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_GRID_VISIBLE);
            this.getShowTableGridCheck().setSelected(showGrid);
            Boolean altRowColors = (Boolean)tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_ALTERNATE_ROW_COLORS);
            this.getAltRowColorsCheck().setSelected(altRowColors);
        }
    }

    private void init() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(LookAndFeelUtil.isWinLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getShowTableGridCheck(), -1, -1, Short.MAX_VALUE).addComponent(this.getAltRowColorsCheck(), -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.getShowTableGridCheck(), -2, -1, -2).addComponent(this.getAltRowColorsCheck(), -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.getShowTableGridCheck(), this.getAltRowColorsCheck()});
        GeneralOptionsControl.setAquaStyle(this.getShowTableGridCheck(), this.getAltRowColorsCheck());
    }

    private JCheckBox getShowTableGridCheck() {
        if (this.showTableGridCheck == null) {
            this.showTableGridCheck = new JCheckBox("Show Table Grid");
            this.showTableGridCheck.setHorizontalAlignment(2);
            this.showTableGridCheck.addActionListener(evt -> this.apply(BasicTableVisualLexicon.TABLE_GRID_VISIBLE, this.showTableGridCheck.isSelected()));
        }
        return this.showTableGridCheck;
    }

    private JCheckBox getAltRowColorsCheck() {
        if (this.altRowColorsCheck == null) {
            this.altRowColorsCheck = new JCheckBox("Alternate Row Colors");
            this.altRowColorsCheck.setHorizontalAlignment(2);
            this.altRowColorsCheck.addActionListener(evt -> this.apply(BasicTableVisualLexicon.TABLE_ALTERNATE_ROW_COLORS, this.altRowColorsCheck.isSelected()));
            this.altRowColorsCheck.setVisible(this.objType != CyNetwork.class);
        }
        return this.altRowColorsCheck;
    }
}

