/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.Component;
import java.util.Collections;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class TableChooserCellRenderer
extends DefaultListCellRenderer {
    private final Map<CyTable, String> tableToStringMap;
    private final CyNetworkTableManager netTableManager;

    TableChooserCellRenderer(CyServiceRegistrar seviceRegistrar) {
        this(Collections.emptyMap(), seviceRegistrar);
    }

    TableChooserCellRenderer(Map<CyTable, String> tableToStringMap, CyServiceRegistrar seviceRegistrar) {
        this.tableToStringMap = tableToStringMap;
        this.netTableManager = (CyNetworkTableManager)seviceRegistrar.getService(CyNetworkTableManager.class);
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (!(value instanceof CyTable)) {
            this.setText("-- No Table --");
            return this;
        }
        CyTable table = (CyTable)value;
        Object text = this.tableToStringMap.get(table);
        if (text == null) {
            String namespace = this.netTableManager.getTableNamespace(table);
            Class type = this.netTableManager.getTableType(table);
            if (type != null && "USER".equals(namespace)) {
                text = "Default " + type.getSimpleName().replace("Cy", "") + " Table";
            } else {
                text = table.getTitle();
                if (!((String)text).toLowerCase().contains("table")) {
                    text = (String)text + " Table";
                }
                if (table != null && !table.isPublic()) {
                    text = (String)text + " [ PRIVATE ]";
                }
            }
        }
        this.setText((String)text);
        if (!isSelected) {
            this.setForeground(table.isPublic() ? list.getForeground() : LookAndFeelUtil.getErrorColor());
        }
        return this;
    }
}

