/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.view;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.browser.internal.util.TableBrowserUtil;
import org.cytoscape.browser.internal.util.ViewUtil;
import org.cytoscape.browser.internal.view.AbstractTableBrowser;
import org.cytoscape.browser.internal.view.TableChooserCellRenderer;
import org.cytoscape.browser.internal.view.tools.AbstractToolBarControl;
import org.cytoscape.browser.internal.view.tools.GeneralOptionsControl;
import org.cytoscape.browser.internal.view.tools.RowHeightControl;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.TablePrivacyChangedEvent;
import org.cytoscape.model.events.TablePrivacyChangedListener;
import org.cytoscape.service.util.CyServiceRegistrar;

public class GlobalTableBrowser
extends AbstractTableBrowser
implements TablePrivacyChangedListener {
    private GlobalTableChooser tableChooser;

    public GlobalTableBrowser(String tabTitle, CyServiceRegistrar serviceRegistrar) {
        super(tabTitle, null, serviceRegistrar);
        List<AbstractToolBarControl> controls = List.of(new RowHeightControl(serviceRegistrar), new GeneralOptionsControl(serviceRegistrar));
        this.getOptionsBar().setFormatControls(controls);
    }

    public String getIdentifier() {
        return "org.cytoscape.UnassignedTables";
    }

    public void setCurrentTable() {
        CyTable table = (CyTable)this.getTableChooser().getSelectedItem();
        if (table == this.currentTable || table == null) {
            return;
        }
        this.setCurrentTable(table);
        this.showSelectedTable();
        ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).setCurrentTable(table);
    }

    public void handleEvent(TablePrivacyChangedEvent e) {
        CyTable table = (CyTable)e.getSource();
        GlobalTableComboBoxModel comboBoxModel = (GlobalTableComboBoxModel)this.getTableChooser().getModel();
        boolean showPrivateTables = TableBrowserUtil.isShowPrivateTables(this.serviceRegistrar);
        if (!table.isPublic() && !showPrivateTables) {
            comboBoxModel.removeElement(table);
            if (comboBoxModel.getSize() == 0) {
                ViewUtil.invokeOnEDT(() -> {
                    this.getTableChooser().setEnabled(false);
                    this.removeTable(table);
                    this.serviceRegistrar.unregisterService((Object)this, CytoPanelComponent.class);
                    this.showSelectedTable();
                });
            }
        } else if (table.isPublic() || showPrivateTables) {
            ViewUtil.invokeOnEDT(() -> {
                comboBoxModel.addElement(table);
                comboBoxModel.setSelectedItem(table);
            });
        }
        ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).setCurrentTable(this.currentTable);
    }

    protected GlobalTableChooser getTableChooser() {
        if (this.tableChooser == null) {
            this.tableChooser = new GlobalTableChooser();
            this.tableChooser.addActionListener(e -> this.setCurrentTable());
            this.tableChooser.setMaximumSize(new Dimension(600, this.tableChooser.getPreferredSize().height));
            this.tableChooser.setToolTipText("Data tables not associated with specific networks");
        }
        return this.tableChooser;
    }

    private class GlobalTableComboBoxModel
    extends DefaultComboBoxModel<CyTable> {
        private final Comparator<CyTable> tableComparator;
        private final Map<CyTable, String> tableToStringMap;
        private final List<CyTable> tables;

        GlobalTableComboBoxModel(Map<CyTable, String> tableToStringMap) {
            this.tableToStringMap = tableToStringMap;
            this.tables = new ArrayList<CyTable>();
            this.tableComparator = new Comparator<CyTable>(){

                @Override
                public int compare(CyTable table1, CyTable table2) {
                    return table1.getTitle().compareTo(table2.getTitle());
                }
            };
        }

        private void updateTableToStringMap() {
            this.tableToStringMap.clear();
            for (CyTable table : this.tables) {
                this.tableToStringMap.put(table, table.getTitle());
            }
        }

        @Override
        public int getIndexOf(Object obj) {
            return this.tables.indexOf(obj);
        }

        @Override
        public int getSize() {
            return this.tables.size();
        }

        @Override
        public CyTable getElementAt(int index) {
            return this.tables.get(index);
        }

        @Override
        public void addElement(CyTable table) {
            if (!this.tables.contains(table)) {
                this.tables.add(table);
                Collections.sort(this.tables, this.tableComparator);
                this.updateTableToStringMap();
                this.fireContentsChanged(this, 0, this.tables.size() - 1);
            }
        }

        @Override
        public void removeElement(Object table) {
            if (this.tables.contains(table)) {
                this.tables.remove(table);
                if (this.tables.isEmpty()) {
                    this.setSelectedItem(null);
                } else {
                    Collections.sort(this.tables, this.tableComparator);
                    this.setSelectedItem(this.tables.get(0));
                }
            }
        }
    }

    private class GlobalTableChooser
    extends JComboBox<CyTable> {
        private final Map<CyTable, String> tableToStringMap = new HashMap<CyTable, String>();

        GlobalTableChooser() {
            this.setModel(new GlobalTableComboBoxModel(this.tableToStringMap));
            this.setRenderer(new TableChooserCellRenderer(this.tableToStringMap, GlobalTableBrowser.this.serviceRegistrar));
        }
    }
}

