/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.task;

import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public final class DeleteTableTask
extends AbstractTableTask {
    @Tunable(description="Are you sure you want to delete this table?", params="ForceSetDirectly=true;ForceSetTitle=Delete Table", context="gui")
    public boolean confirm;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Delete Table";
    }

    public DeleteTableTask(CyTable table, CyServiceRegistrar serviceRegistrar) {
        super(table);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        if (this.confirm) {
            tm.setTitle("Delete Table");
            if (this.table.getMutability() == CyTable.Mutability.MUTABLE) {
                tm.setStatusMessage("Deleting table: " + this.table + "...");
                ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).deleteTable(this.table.getSUID().longValue());
            } else {
                throw new RuntimeException(this.table.getMutability() == CyTable.Mutability.IMMUTABLE_DUE_TO_VIRT_COLUMN_REFERENCES ? "Cannot delete this table, it is immutable due to virtual column references." : "Cannot delete this table, it is immutable.");
            }
        }
    }
}

