/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.format;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.util.IllegalFormatException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicIconFactory;
import org.cytoscape.browser.internal.view.TableRenderer;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class SetColumnFormatDialog
extends JDialog {
    public static final String FLOAT_FORMAT_PROPERTY = "floatingPointColumnFormat";
    private static final double FORMAT_EXAMPLE_NUM = 1234.5678909876542;
    private JPanel samplePanel;
    private JPanel formatPanel;
    private JPanel advancedPanel;
    private JButton decimalDecreaseButton;
    private JLabel formatExampleLabel;
    private JButton decimalIncreaseButton;
    private JCheckBox scientificNotationCheckBox;
    private JButton removeFormatButton;
    private JTextField formatEntry;
    private JButton okButton;
    private JButton cancelButton;
    private JButton setDefaultButton;
    private JButton clearDefaultButton;
    private int decimalPlaces = 4;
    private boolean scientificNotation = false;
    private final TableRenderer tableRenderer;
    private final String targetAttrName;
    private final CyProperty<Properties> props;

    public SetColumnFormatDialog(TableRenderer tableRenderer, Frame parent, String targetAttrName, CyServiceRegistrar serviceRegistrar) {
        super((Window)parent, "Set Column Format for: " + targetAttrName, Dialog.ModalityType.APPLICATION_MODAL);
        this.props = (CyProperty)serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)");
        this.targetAttrName = targetAttrName;
        this.tableRenderer = tableRenderer;
        String format = tableRenderer.getColumnFormat(targetAttrName);
        this.loadFormat(format);
        this.initComponents();
    }

    private void loadFormat(String format) {
        if (format == null) {
            format = ((Properties)this.props.getProperties()).getProperty(FLOAT_FORMAT_PROPERTY);
        }
        if (format != null) {
            Pattern p = Pattern.compile("\\.(\\d*)(e|f)$");
            Matcher m = p.matcher(format);
            if (m.find()) {
                this.decimalPlaces = Integer.parseInt(m.group(1));
                this.scientificNotation = m.group(2).equals("e");
                this.getScientificNotationCheckBox().setSelected(this.scientificNotation);
            }
            this.getFormatEntry().setText(format);
        }
    }

    private void initComponents() {
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)this.getOkButton(), (JButton)this.getCancelButton(), (JComponent[])new JComponent[]{this.getRemoveFormatButton()});
        JPanel contents = new JPanel();
        GroupLayout layout = new GroupLayout(contents);
        contents.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getSamplePanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getFormatPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getAdvancedPanel(), -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getSamplePanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getFormatPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getAdvancedPanel(), -1, -1, Short.MAX_VALUE).addComponent(buttonPanel, -1, -1, Short.MAX_VALUE));
        this.getContentPane().add(contents);
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getOkButton().getAction(), (Action)this.getCancelButton().getAction());
        this.getRootPane().setDefaultButton(this.getOkButton());
        this.pack();
        this.setResizable(false);
    }

    private JPanel getSamplePanel() {
        if (this.samplePanel == null) {
            this.samplePanel = new JPanel();
            this.samplePanel.setBorder(LookAndFeelUtil.createTitledBorder((String)"Sample"));
            this.samplePanel.setLayout(new BorderLayout());
            this.samplePanel.add((Component)this.getFormatExampleLabel(), "Center");
            this.getFormatExampleLabel().setPreferredSize(new Dimension(200, 25));
            this.getFormatExampleLabel().setMaximumSize(new Dimension(200, 25));
            this.getFormatExampleLabel().setMinimumSize(new Dimension(200, 25));
        }
        return this.samplePanel;
    }

    private JPanel getFormatPanel() {
        if (this.formatPanel == null) {
            this.formatPanel = new JPanel();
            GroupLayout layout = new GroupLayout(this.formatPanel);
            this.formatPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.getDecimalDecreaseButton(), -1, 32, 32).addComponent(this.getDecimalIncreaseButton(), -1, 32, 32).addComponent(this.getScientificNotationCheckBox()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getDecimalDecreaseButton(), -1, 32, 32).addComponent(this.getDecimalIncreaseButton(), -1, 32, 32).addComponent(this.getScientificNotationCheckBox()));
        }
        return this.formatPanel;
    }

    private JPanel getAdvancedPanel() {
        if (this.advancedPanel == null) {
            this.advancedPanel = new JPanel();
            this.advancedPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            JCheckBox advancedToggle = new JCheckBox("Advanced");
            Icon right = BasicIconFactory.getMenuArrowIcon();
            advancedToggle.setIcon(right);
            ExpandedArrow down = new ExpandedArrow();
            advancedToggle.setSelectedIcon(down);
            this.advancedPanel.add((Component)advancedToggle, c);
            c.gridx = 1;
            c.weightx = 1.0;
            this.advancedPanel.add((Component)new JSeparator(0), c);
            final JPanel advancedSubpanel = new JPanel();
            advancedToggle.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    advancedSubpanel.setVisible(((JCheckBox)e.getSource()).isSelected());
                    SetColumnFormatDialog.this.pack();
                }
            });
            advancedSubpanel.setLayout(new GridBagLayout());
            advancedSubpanel.setBorder(LookAndFeelUtil.createPanelBorder());
            c.insets = new Insets(3, 3, 3, 3);
            JLabel formatLabel = new JLabel("Format Spec: ");
            c.gridx = 0;
            c.gridy = 0;
            advancedSubpanel.add((Component)formatLabel, c);
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 2;
            advancedSubpanel.add((Component)this.getFormatEntry(), c);
            c.gridwidth = 1;
            c.gridx = 1;
            c.gridy = 1;
            advancedSubpanel.add((Component)this.getClearDefaultButton(), c);
            c.gridx = 2;
            advancedSubpanel.add((Component)this.getSetDefaultButton(), c);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.gridheight = 2;
            this.advancedPanel.add((Component)advancedSubpanel, c);
            advancedSubpanel.setVisible(false);
        }
        return this.advancedPanel;
    }

    private JCheckBox getScientificNotationCheckBox() {
        if (this.scientificNotationCheckBox == null) {
            this.scientificNotationCheckBox = new JCheckBox("Scientific Notation", this.scientificNotation);
            this.scientificNotationCheckBox.setToolTipText("Toggle scientific notation formatting");
            this.scientificNotationCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetColumnFormatDialog.this.scientificNotation = SetColumnFormatDialog.this.scientificNotationCheckBox.isSelected();
                    SetColumnFormatDialog.this.updateFormatEntry();
                }
            });
        }
        return this.scientificNotationCheckBox;
    }

    private JButton getRemoveFormatButton() {
        if (this.removeFormatButton == null) {
            this.removeFormatButton = new JButton("Remove Format");
            this.removeFormatButton.setToolTipText("Reset to default Cytoscape column format");
            this.removeFormatButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetColumnFormatDialog.this.dispose();
                }
            });
        }
        return this.removeFormatButton;
    }

    private JButton getSetDefaultButton() {
        if (this.setDefaultButton == null) {
            this.setDefaultButton = new JButton("Save As Default");
            this.setDefaultButton.setToolTipText("Make default Cytoscape column format");
            this.setDefaultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SetColumnFormatDialog.this.getFormatExampleLabel() != null) {
                        ((Properties)SetColumnFormatDialog.this.props.getProperties()).setProperty(SetColumnFormatDialog.FLOAT_FORMAT_PROPERTY, SetColumnFormatDialog.this.getFormatEntry().getText());
                    }
                }
            });
        }
        return this.setDefaultButton;
    }

    private JButton getClearDefaultButton() {
        if (this.clearDefaultButton == null) {
            this.clearDefaultButton = new JButton("Clear Default");
            this.clearDefaultButton.setToolTipText("Reset default Cytoscape column format");
            this.clearDefaultButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Properties)SetColumnFormatDialog.this.props.getProperties()).remove(SetColumnFormatDialog.FLOAT_FORMAT_PROPERTY);
                }
            });
        }
        return this.clearDefaultButton;
    }

    private JButton getDecimalIncreaseButton() {
        if (this.decimalIncreaseButton == null) {
            ImageIcon ico = new ImageIcon(this.getClass().getResource("/images/decimalIncrease.png"));
            this.decimalIncreaseButton = new JButton(ico);
            this.decimalIncreaseButton.setToolTipText("Increase decimal precision");
            this.decimalIncreaseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetColumnFormatDialog.this.decimalPlaces = Math.min(16, SetColumnFormatDialog.this.decimalPlaces + 1);
                    SetColumnFormatDialog.this.updateFormatEntry();
                }
            });
        }
        return this.decimalIncreaseButton;
    }

    private JTextField getFormatEntry() {
        if (this.formatEntry == null) {
            this.formatEntry = new JTextField("%.4f");
            this.formatEntry.setToolTipText("The formatting rule that is applied to all values in the column");
            this.formatEntry.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SetColumnFormatDialog.this.formatFieldChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SetColumnFormatDialog.this.formatFieldChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SetColumnFormatDialog.this.formatFieldChanged();
                }
            });
        }
        this.formatEntry.setBorder(BorderFactory.createEmptyBorder());
        return this.formatEntry;
    }

    private JButton getDecimalDecreaseButton() {
        if (this.decimalDecreaseButton == null) {
            ImageIcon ico = new ImageIcon(this.getClass().getResource("/images/decimalDecrease.png"));
            this.decimalDecreaseButton = new JButton(ico);
            this.decimalDecreaseButton.setToolTipText("Decrease decimal precision");
            this.decimalDecreaseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetColumnFormatDialog.this.decimalPlaces = Math.max(0, SetColumnFormatDialog.this.decimalPlaces - 1);
                    SetColumnFormatDialog.this.updateFormatEntry();
                }
            });
        }
        return this.decimalDecreaseButton;
    }

    private JLabel getFormatExampleLabel() {
        if (this.formatExampleLabel == null) {
            this.formatExampleLabel = new JLabel(String.format(this.getFormatEntry().getText(), 1234.5678909876542));
            this.formatExampleLabel.setHorizontalAlignment(0);
        }
        return this.formatExampleLabel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(new AbstractAction("Apply"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetColumnFormatDialog.this.updateCells();
                    SetColumnFormatDialog.this.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetColumnFormatDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    private void formatFieldChanged() {
        boolean valid = false;
        if (this.getFormattedExample() != null) {
            this.getFormatEntry().setBorder(BorderFactory.createEmptyBorder());
            this.updateFormatExampleLabel();
            valid = true;
        } else {
            this.getFormatEntry().setBorder(BorderFactory.createLineBorder(Color.RED, 2));
        }
        this.getOkButton().setEnabled(valid);
        this.getSetDefaultButton().setEnabled(valid);
    }

    private String getFormattedExample() {
        String formatted = String.valueOf(1234.5678909876542);
        String newStr = this.formatEntry.getText();
        if (newStr.isEmpty()) {
            newStr = ((Properties)this.props.getProperties()).getProperty(FLOAT_FORMAT_PROPERTY);
        }
        if (newStr != null) {
            try {
                formatted = String.format(newStr, 1234.5678909876542);
            }
            catch (IllegalFormatException e) {
                return null;
            }
        }
        return formatted;
    }

    private void updateFormatEntry() {
        String formatStr = String.format("%%.%d%c", this.decimalPlaces, Character.valueOf(this.getScientificNotationCheckBox().isSelected() ? (char)'e' : 'f'));
        this.getFormatEntry().setText(formatStr);
    }

    private void updateFormatExampleLabel() {
        String format = this.getFormattedExample();
        this.getFormatExampleLabel().setText(format);
        this.pack();
    }

    private void updateCells() {
        String format = this.getFormatEntry().getText();
        if (format.isEmpty()) {
            format = null;
        }
        this.tableRenderer.setColumnFormat(this.targetAttrName, format);
    }

    private class ExpandedArrow
    extends ImageIcon {
        private ExpandedArrow() {
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            AffineTransform init = g2.getTransform();
            g2.translate(c.getHeight() / 3, c.getHeight() / 2);
            g2.rotate(1.5707963267948966, 0.0, 0.0);
            g2.translate(-c.getHeight() / 3, -c.getHeight() / 2);
            icon.paintIcon(c, g, x, y);
            g2.setTransform(init);
        }
    }
}

