/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.browser.internal.view.DeletionDialog;
import org.cytoscape.browser.internal.view.TableBrowserMediator;
import org.cytoscape.browser.internal.view.TableRenderer;

public class DeleteColumnsAction
extends AbstractCyAction {
    private static String TITLE = "Delete Columns...";
    private final TableBrowserMediator mediator;

    public DeleteColumnsAction(Icon icon, float toolbarGravity, TableBrowserMediator mediator) {
        super(TITLE);
        this.mediator = mediator;
        this.putValue("ShortDescription", TITLE);
        this.putValue("SwingLargeIconKey", icon);
        this.setIsInNodeTableToolBar(true);
        this.setIsInEdgeTableToolBar(true);
        this.setIsInNetworkTableToolBar(true);
        this.setIsInUnassignedTableToolBar(true);
        this.setToolbarGravity(toolbarGravity);
        this.insertSeparatorAfter = true;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Component) {
            this.showColumnDeletionDialog((Component)source);
        }
    }

    private void showColumnDeletionDialog(Component invoker) {
        JFrame frame = (JFrame)SwingUtilities.getRoot(invoker);
        TableRenderer renderer = this.mediator.getCurrentTableRenderer();
        if (renderer != null) {
            DeletionDialog dialog = new DeletionDialog((Frame)frame, renderer.getDataTable());
            dialog.pack();
            dialog.setLocationRelativeTo(invoker);
            dialog.setVisible(true);
        }
    }

    public void updateEnableState() {
        TableRenderer renderer = this.mediator.getCurrentTableRenderer();
        this.setEnabled(renderer != null && renderer.getDataTable().getColumns().stream().anyMatch(col -> !col.isImmutable()));
    }
}

