/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.browser.internal.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.browser.internal.view.TableBrowserMediator;
import org.cytoscape.browser.internal.view.TableRenderer;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;

public class CreateColumnAction
extends AbstractCyAction {
    private static String TITLE = "Create New Column...";
    private final TableBrowserMediator mediator;
    private final CyServiceRegistrar serviceRegistrar;

    public CreateColumnAction(Icon icon, float toolbarGravity, TableBrowserMediator mediator, CyServiceRegistrar serviceRegistrar) {
        super(TITLE);
        this.mediator = mediator;
        this.serviceRegistrar = serviceRegistrar;
        this.putValue("ShortDescription", TITLE);
        this.putValue("SwingLargeIconKey", icon);
        this.setIsInNodeTableToolBar(true);
        this.setIsInEdgeTableToolBar(true);
        this.setIsInNetworkTableToolBar(true);
        this.setIsInUnassignedTableToolBar(true);
        this.setToolbarGravity(toolbarGravity);
        this.insertSeparatorBefore = true;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Component) {
            this.showCreateColumnPopup((Component)source);
        }
    }

    private void showCreateColumnPopup(Component invoker) {
        JPopupMenu popup = new JPopupMenu();
        JMenu columnRegular = new JMenu("New Single Column");
        JMenu columnList = new JMenu("New List Column");
        columnRegular.add(this.getJMenuItemIntegerAttribute(false));
        columnRegular.add(this.getJMenuItemLongIntegerAttribute(false));
        columnRegular.add(this.getJMenuItemStringAttribute(false));
        columnRegular.add(this.getJMenuItemFloatingPointAttribute(false));
        columnRegular.add(this.getJMenuItemBooleanAttribute(false));
        columnList.add(this.getJMenuItemIntegerListAttribute(false));
        columnList.add(this.getJMenuItemLongIntegerListAttribute(false));
        columnList.add(this.getJMenuItemStringListAttribute(false));
        columnList.add(this.getJMenuItemFloatingPointListAttribute(false));
        columnList.add(this.getJMenuItemBooleanListAttribute(false));
        popup.add(columnRegular);
        popup.add(columnList);
        popup.pack();
        popup.show(invoker, 0, invoker.getHeight());
    }

    private JMenuItem getJMenuItemStringAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("String");
        mi.addActionListener(e -> this.createNewAttribute("String", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemIntegerAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Integer");
        mi.addActionListener(e -> this.createNewAttribute("Integer", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemLongIntegerAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Long Integer");
        mi.addActionListener(e -> this.createNewAttribute("Long Integer", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemFloatingPointAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Floating Point");
        mi.addActionListener(e -> this.createNewAttribute("Floating Point", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemBooleanAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Boolean");
        mi.addActionListener(e -> this.createNewAttribute("Boolean", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemStringListAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("String");
        mi.addActionListener(e -> this.createNewAttribute("String List", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemIntegerListAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Integer");
        mi.addActionListener(e -> this.createNewAttribute("Integer List", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemLongIntegerListAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Long Integer");
        mi.addActionListener(e -> this.createNewAttribute("Long Integer List", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemFloatingPointListAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Floating Point");
        mi.addActionListener(e -> this.createNewAttribute("Floating Point List", isShared));
        return mi;
    }

    private JMenuItem getJMenuItemBooleanListAttribute(boolean isShared) {
        JMenuItem mi = new JMenuItem();
        mi.setText("Boolean");
        mi.addActionListener(e -> this.createNewAttribute("Boolean List", isShared));
        return mi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createNewAttribute(String type, boolean isShared) {
        try {
            TableRenderer renderer = this.mediator.getCurrentTableRenderer();
            Object[] existingAttrs = this.getAttributeArray(renderer);
            String newAttribName = null;
            do {
                if ((newAttribName = JOptionPane.showInputDialog(renderer.getComponent(), "Column Name: ", "Create New " + type + " Column", 3)) == null) {
                    return;
                }
                if ((newAttribName = newAttribName.trim()).isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Column name must not be blank.", "Error", 0);
                    newAttribName = null;
                    continue;
                }
                if (Arrays.binarySearch(existingAttrs, newAttribName) < 0) continue;
                JOptionPane.showMessageDialog(null, "Column " + newAttribName + " already exists.", "Error", 0);
                newAttribName = null;
            } while (newAttribName == null);
            CyTable attrs = null;
            if (isShared) {
                CyTable sharedTable;
                CyNetwork network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
                if (!(network instanceof CySubNetwork)) throw new IllegalArgumentException("This is not a CySubNetwork and there is no shared table.");
                CyRootNetwork rootNetwork = ((CySubNetwork)network).getRootNetwork();
                Class<? extends CyIdentifiable> objType = this.mediator.getTableBrowser(renderer).getObjectType();
                if (objType == CyNode.class) {
                    sharedTable = rootNetwork.getSharedNodeTable();
                } else if (objType == CyEdge.class) {
                    sharedTable = rootNetwork.getSharedEdgeTable();
                } else {
                    if (objType != CyNetwork.class) throw new IllegalStateException("Object type is not valid.  This should not happen.");
                    sharedTable = rootNetwork.getSharedNetworkTable();
                }
                attrs = sharedTable;
            } else {
                if (renderer == null) return;
                CyTable cyTable = renderer.getDataTable();
                attrs = cyTable;
            }
            if (attrs == null) return;
            if (type.equals("String")) {
                attrs.createColumn(newAttribName, String.class, false);
                return;
            } else if (type.equals("Floating Point")) {
                attrs.createColumn(newAttribName, Double.class, false);
                return;
            } else if (type.equals("Integer")) {
                attrs.createColumn(newAttribName, Integer.class, false);
                return;
            } else if (type.equals("Long Integer")) {
                attrs.createColumn(newAttribName, Long.class, false);
                return;
            } else if (type.equals("Boolean")) {
                attrs.createColumn(newAttribName, Boolean.class, false);
                return;
            } else if (type.equals("String List")) {
                attrs.createListColumn(newAttribName, String.class, false);
                return;
            } else if (type.equals("Floating Point List")) {
                attrs.createListColumn(newAttribName, Double.class, false);
                return;
            } else if (type.equals("Integer List")) {
                attrs.createListColumn(newAttribName, Integer.class, false);
                return;
            } else if (type.equals("Long Integer List")) {
                attrs.createListColumn(newAttribName, Long.class, false);
                return;
            } else {
                if (!type.equals("Boolean List")) throw new IllegalArgumentException("unknown column type \"" + type + "\".");
                attrs.createListColumn(newAttribName, Boolean.class, false);
            }
            return;
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
        }
    }

    private String[] getAttributeArray(TableRenderer renderer) {
        if (renderer == null) {
            return new String[0];
        }
        CyTable attrs = renderer.getDataTable();
        Collection columns = attrs.getColumns();
        Object[] attributeArray = new String[columns.size() - 1];
        int index = 0;
        for (CyColumn col : columns) {
            if (col.isPrimaryKey()) continue;
            attributeArray[index++] = col.getName();
        }
        Arrays.sort(attributeArray);
        return attributeArray;
    }
}

