/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.view;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.StatusBarPanelFactory;

public class TaskStatusBar
extends JPanel
implements StatusBarPanelFactory {
    public static final String TASK_HISTORY_CLICK = "task-history-click";
    private static final int CLEAR_DELAY_MS = 5000;
    private final JLabel titleIconLabel;
    private final JLabel titleLabel;
    private final JButton showBtn;
    private final Timer clearingTimer;

    public TaskStatusBar(CyServiceRegistrar serviceRegistrar) {
        IconManager iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.titleIconLabel = new JLabel();
        this.titleIconLabel.setFont(iconManager.getIconFont(14.0f));
        this.titleLabel = new JLabel();
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.titleLabel});
        this.showBtn = new JButton(GUIDefaults.TaskIcon.TASKS.getText());
        this.showBtn.setFont(iconManager.getIconFont(14.0f));
        if (LookAndFeelUtil.isAquaLAF()) {
            this.showBtn.putClientProperty("JButton.buttonType", "gradient");
        }
        this.showBtn.setToolTipText("Show Tasks");
        this.showBtn.setFocusPainted(false);
        this.showBtn.addActionListener(evt -> {
            this.showBtn.setText(GUIDefaults.TaskIcon.TASKS.getText());
            this.showBtn.setForeground(GUIDefaults.TaskIcon.TASKS.getForeground());
            this.firePropertyChange(TASK_HISTORY_CLICK, null, null);
        });
        this.clearingTimer = new Timer(5000, evt -> this.clearStatusBar());
        this.clearingTimer.setRepeats(false);
        int w = Math.max(48, this.showBtn.getPreferredSize().width);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(false);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.showBtn, w, w, w).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.titleIconLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleLabel));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.showBtn, -1, -1, Short.MAX_VALUE).addComponent(this.titleIconLabel, -1, -1, Short.MAX_VALUE).addComponent(this.titleLabel, -2, -1, -2));
        this.setPreferredSize(new Dimension(100, this.getPreferredSize().height));
    }

    public void setTitle(FinishStatus.Type finishType, String title) {
        GUIDefaults.TaskIcon icon = GUIDefaults.getIcon(finishType);
        String type = null;
        if (finishType != null) {
            switch (finishType) {
                case SUCCEEDED: {
                    type = "finished";
                    break;
                }
                case FAILED: {
                    type = "error";
                    break;
                }
                case CANCELLED: {
                    type = "cancelled";
                }
            }
        }
        this.setTitle(type, icon, title);
    }

    public void setTitle(TaskMonitor.Level level, String title) {
        GUIDefaults.TaskIcon icon = GUIDefaults.getIcon(level);
        String type = null;
        if (level != null) {
            switch (level) {
                case INFO: {
                    type = "info";
                    break;
                }
                case WARN: {
                    type = "warn";
                    break;
                }
                case ERROR: {
                    type = "error";
                }
            }
        }
        this.setTitle(type, icon, title);
    }

    public void setTitle(String type, GUIDefaults.TaskIcon icon, String title) {
        String iconText = null;
        Color iconColor = null;
        if (icon != null) {
            iconText = icon.getText();
            iconColor = icon.getForeground();
            if (type.equals("error") && !icon.getText().equalsIgnoreCase(this.showBtn.getText()) || type.equals("warn") && GUIDefaults.TaskIcon.TASKS.getText().equalsIgnoreCase(this.showBtn.getText())) {
                this.showBtn.setText(iconText);
                this.showBtn.setForeground(iconColor);
            }
        }
        this.titleIconLabel.setText(title == null || title.isEmpty() ? null : iconText);
        this.titleLabel.setText(title);
        if (iconColor != null) {
            this.titleIconLabel.setForeground(iconColor);
        }
        this.clearingTimer.restart();
    }

    private void clearStatusBar() {
        this.titleIconLabel.setText(null);
        this.titleLabel.setText("");
    }

    public JPanel createTaskStatusPanel() {
        return this;
    }
}

