/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.view;

import java.util.Properties;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.internal.task.TaskHistory;
import org.cytoscape.work.internal.tunables.utils.ViewUtil;
import org.cytoscape.work.internal.view.TaskHistoryWindow;
import org.cytoscape.work.internal.view.TaskStatusBar;
import org.cytoscape.work.swing.StatusBarPanelFactory;

public class TaskMediator
implements CyStartListener {
    private TaskStatusBar taskStatusBar;
    private TaskHistoryWindow window;
    private final TaskHistory taskHistory;
    private final CyServiceRegistrar serviceRegistrar;

    public TaskMediator(TaskHistory taskHistory, CyServiceRegistrar serviceRegistrar) {
        this.taskHistory = taskHistory;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleEvent(CyStartEvent e) {
        if (this.taskStatusBar == null) {
            ViewUtil.invokeOnEDTAndWait(() -> {
                this.taskStatusBar = new TaskStatusBar(this.serviceRegistrar);
            });
            this.taskStatusBar.addPropertyChangeListener("task-history-click", evt -> {
                if (this.window == null) {
                    this.window = new TaskHistoryWindow(this.taskHistory);
                }
                this.window.open();
            });
            Properties props = new Properties();
            props.setProperty("type", "TaskStatus");
            this.serviceRegistrar.registerService((Object)this.taskStatusBar, StatusBarPanelFactory.class, props);
        }
    }

    public void setTitle(TaskMonitor.Level level, String title) {
        if (this.taskStatusBar != null) {
            ViewUtil.invokeOnEDT(() -> this.taskStatusBar.setTitle(level, title));
        }
    }

    public void setTitle(FinishStatus.Type type, String title) {
        if (this.taskStatusBar != null) {
            ViewUtil.invokeOnEDT(() -> this.taskStatusBar.setTitle(type, title));
        }
    }
}

