/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.view;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.internal.task.TaskHistory;
import org.cytoscape.work.internal.tunables.utils.ColorUtil;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.internal.tunables.utils.ViewUtil;

public class TaskHistoryWindow {
    final TaskHistory taskHistory;
    final JDialog dialog;
    final JEditorPane pane;

    public TaskHistoryWindow(TaskHistory taskHistory) {
        this.taskHistory = taskHistory;
        this.dialog = new JDialog(null, "Cytoscape Task History", Dialog.ModalityType.MODELESS);
        this.dialog.setDefaultCloseOperation(2);
        this.pane = new JEditorPane();
        this.pane.setEditable(false);
        this.pane.setContentType("text/html");
        int fontSize = (int)LookAndFeelUtil.getSmallFontSize();
        String fontFamily = "\"Courier New\", monospace";
        HTMLEditorKit htmlEditorKit = (HTMLEditorKit)this.pane.getEditorKit();
        StyleSheet styleSheet = htmlEditorKit.getStyleSheet();
        styleSheet.addRule("h1, h2, h3, p { font-family: \"Courier New\", monospace; font-size:" + fontSize + "px; }");
        styleSheet.addRule("ul { list-style-type: none; font-family: \"Courier New\", monospace; font-size:" + fontSize + "px; }");
        JButton clearButton = new JButton("Clear Display");
        clearButton.addActionListener(evt -> {
            taskHistory.clear();
            this.update();
        });
        JButton closeButton = new JButton(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskHistoryWindow.this.dialog.dispose();
            }
        });
        JPanel buttonsPanel = LookAndFeelUtil.createOkCancelPanel(null, (JButton)closeButton, (JComponent[])new JComponent[]{clearButton});
        buttonsPanel.add(clearButton);
        JScrollPane scrollPane = new JScrollPane(this.pane);
        GroupLayout layout = new GroupLayout(this.dialog.getContentPane());
        this.dialog.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(scrollPane, -1, 500, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(buttonsPanel).addContainerGap()));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(scrollPane, -1, 400, Short.MAX_VALUE).addComponent(buttonsPanel, -2, -1, -2).addContainerGap());
        LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.dialog.getRootPane(), null, (Action)closeButton.getAction());
        this.dialog.getRootPane().setDefaultButton(closeButton);
        taskHistory.setFinishListener(new TaskHistory.FinishListener(){

            @Override
            public void taskFinished(TaskHistory.History history) {
                TaskHistoryWindow.this.update();
            }
        });
        this.dialog.pack();
        this.open();
    }

    public void open() {
        this.update();
        this.dialog.setVisible(true);
    }

    private void generateMessage(TaskHistory.Message message, StringBuffer buffer) {
        TaskMonitor.Level level = message.level();
        String iconText = GUIDefaults.getIconText(level);
        if (iconText != null) {
            Color color = GUIDefaults.getForeground(level);
            String fg = ColorUtil.toHexString(color);
            buffer.append("<li style='margin-top: 5px;'>");
            buffer.append("<span style='font-family: FontAwesome; color: " + fg + ";'>" + iconText + "</span>&nbsp;");
        } else {
            buffer.append("<li style='margin-top: 10px;'>");
            buffer.append("<b>");
        }
        buffer.append(message.message());
        if (level == null) {
            buffer.append("</b>");
        }
        buffer.append("</li>");
    }

    private void generateHistory(TaskHistory.History history, StringBuffer buffer) {
        String title;
        String iconText;
        if (history.getFirstTaskClass() == null) {
            return;
        }
        buffer.append("<p>");
        buffer.append("<h1 style='margin-top: 0px; margin-bottom: 0px;'>&nbsp;");
        FinishStatus.Type finishType = history.getFinishType();
        GUIDefaults.TaskIcon icon = GUIDefaults.getIcon(finishType);
        String string = iconText = icon != null ? icon.getText() : null;
        if (iconText != null) {
            Color color = GUIDefaults.getForeground(iconText);
            String fg = ColorUtil.toHexString(color);
            buffer.append("<span style='font-family: FontAwesome; color: " + fg + ";'>" + iconText + "</span>&nbsp;");
        }
        if ((title = history.getTitle()) == null || title.length() == 0) {
            buffer.append("<i>Untitled</i>");
            Class<?> klass = history.getFirstTaskClass();
            if (klass != null) {
                buffer.append(" <font size='-1'>(");
                buffer.append(klass.getName());
                buffer.append(")</font>");
            }
        } else {
            buffer.append(title);
        }
        buffer.append("</h1>");
        buffer.append("<ul style='margin-top: 0px; margin-bottom: 0px;'>");
        for (TaskHistory.Message message : history) {
            this.generateMessage(message, buffer);
        }
        buffer.append("</ul>");
        buffer.append("</p><br>");
    }

    private String generateHistoryHTML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        for (Object element : this.taskHistory) {
            if (element instanceof TaskHistory.History) {
                this.generateHistory((TaskHistory.History)element, buffer);
                continue;
            }
            if (!(element instanceof TaskHistory.Message)) continue;
            buffer.append("<ul style='margin-top: 0px; margin-bottom: 0px; margin-left: 0px; padding-left: 0px;'>");
            this.generateMessage((TaskHistory.Message)element, buffer);
            buffer.append("</ul>");
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public void update() {
        String content = this.generateHistoryHTML();
        ViewUtil.invokeOnEDT(() -> this.pane.setText(content));
    }
}

