/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.CyFileFilterProvider;
import org.cytoscape.io.DataCategory;
import org.cytoscape.io.read.InputStreamTaskFactory;
import org.cytoscape.io.write.CyWriterFactory;
import org.cytoscape.util.swing.FileChooserFilter;

public class SupportedFileTypesManager {
    Set<CyFileFilterProvider> inputFactories = new HashSet<CyFileFilterProvider>();
    Set<CyFileFilterProvider> outputFactories = new HashSet<CyFileFilterProvider>();

    public void addInputStreamTaskFactory(InputStreamTaskFactory factory, Map<?, ?> properties) {
        this.inputFactories.add((CyFileFilterProvider)factory);
    }

    public void removeInputStreamTaskFactory(InputStreamTaskFactory factory, Map<?, ?> properties) {
        this.inputFactories.remove(factory);
    }

    public void addCyWriterTaskFactory(CyWriterFactory factory, Map<?, ?> properties) {
        this.outputFactories.add((CyFileFilterProvider)factory);
    }

    public void removeCyWriterTaskFactory(CyWriterFactory factory, Map<?, ?> properties) {
        this.outputFactories.remove(factory);
    }

    public List<FileChooserFilter> getSupportedFileTypes(DataCategory category, boolean input) {
        if (input) {
            return this.getSupportedFileTypes(category, this.inputFactories);
        }
        return this.getSupportedFileTypes(category, this.outputFactories);
    }

    private List<FileChooserFilter> getSupportedFileTypes(DataCategory category, Set<CyFileFilterProvider> factories) {
        ArrayList<FileChooserFilter> types = new ArrayList<FileChooserFilter>();
        HashSet<String> allExtensions = new HashSet<String>();
        for (CyFileFilterProvider factory : factories) {
            CyFileFilter filter = factory.getFileFilter();
            if (filter.getExtensions().contains("cytable") || filter.getDataCategory() != category) continue;
            String description = filter.getDescription();
            Set filterExtensions = filter.getExtensions();
            String[] extensions = new String[filterExtensions.size()];
            int index = 0;
            for (String extension : filterExtensions) {
                allExtensions.add(extension);
                extensions[index] = extension;
                ++index;
            }
            types.add(new FileChooserFilter(description, extensions));
        }
        if (types.isEmpty()) {
            return types;
        }
        Collections.sort(types, new Comparator<FileChooserFilter>(){

            @Override
            public int compare(FileChooserFilter o1, FileChooserFilter o2) {
                return o1.getDescription().compareTo(o2.getDescription());
            }
        });
        String description = String.format("All %1$s files", category.getDisplayName().toLowerCase());
        types.add(new FileChooserFilter(description, new ArrayList(allExtensions).toArray(new String[allExtensions.size()])));
        return types;
    }
}

