/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.swing.GUITunableHandler;

public class SimplePanel
extends JPanel
implements HierarchyListener {
    protected final boolean vertical;
    protected final String title;
    protected JPanel contentPane;

    public SimplePanel(boolean vertical) {
        this(vertical, null);
    }

    protected SimplePanel(boolean vertical, String title) {
        this.vertical = vertical;
        this.title = title;
        this.init();
        this.initComponents();
    }

    protected void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    protected void initComponents() {
        this.addToRoot(this.getContentPane());
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        d.width = Integer.MAX_VALUE;
        return d;
    }

    @Override
    public Component add(Component c) {
        this.adjust(c);
        return this.getContentPane().add(c);
    }

    @Override
    public void add(Component c, Object constraint) {
        this.adjust(c);
        this.getContentPane().add(c, constraint);
    }

    protected Component addToRoot(Component c) {
        this.adjust(c);
        return super.add(c);
    }

    protected void addToRoot(Component c, Object constraint) {
        this.adjust(c);
        super.add(c, constraint);
    }

    protected void addStrutToRoot(int size) {
        this.addToRoot(Box.createVerticalStrut(size));
    }

    protected void adjust(Component c) {
        if (c instanceof JPanel) {
            ((JPanel)c).setAlignmentX(0.5f);
            if (!this.vertical) {
                ((JPanel)c).setAlignmentY(0.0f);
            }
        }
    }

    protected JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BoxLayout(this.contentPane, this.vertical ? 1 : 0));
        }
        return this.contentPane;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (this.isDisplayed() && !this.hasDependentFields(this) && !this.hasEnabledControls(this)) {
            this.setVisible(false);
        }
    }

    public boolean hasDependentFields(JPanel panel) {
        int total = panel.getComponentCount();
        for (int i = 0; i < total; ++i) {
            GUITunableHandler gh;
            Component c = panel.getComponent(i);
            if (!c.isVisible() || !(c instanceof AbstractGUITunableHandler.TunableFieldPanel ? (gh = ((AbstractGUITunableHandler.TunableFieldPanel)c).getTunableHandler()) != null && gh.dependsOn() != null && !gh.dependsOn().trim().isEmpty() : c instanceof JPanel && this.hasDependentFields((JPanel)c))) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnabledControls(JPanel panel) {
        int total = panel.getComponentCount();
        for (int i = 0; i < total; ++i) {
            Component c = panel.getComponent(i);
            if (!c.isVisible() || !c.isEnabled() || !(c instanceof JPanel ? this.hasEnabledControls((JPanel)c) : !(c instanceof Box.Filler))) continue;
            return true;
        }
        return false;
    }

    private boolean isDisplayed() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (c.isVisible()) continue;
            return false;
        }
        return true;
    }
}

