/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color getContrastingColor(Color color) {
        int d = 0;
        double a = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        d = a < 0.5 ? 0 : 255;
        return new Color(d, d, d);
    }

    public static List<Color> getContrastingColors(List<Color> colors) {
        ArrayList<Color> list = new ArrayList<Color>();
        if (colors != null) {
            for (Color c : colors) {
                list.add(ColorUtil.getContrastingColor(c));
            }
        }
        return list;
    }

    public static String toHexString(Color color) {
        int rgb = color.getRGB();
        String hex = String.format("#%06X", 0xFFFFFF & rgb);
        return hex;
    }
}

