/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JButton;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.swing.util.UserAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActionHandler
extends AbstractGUITunableHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private JButton button;

    public UserActionHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
        this.init();
    }

    public UserActionHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private void init() {
        this.button = new JButton(this.getDescription());
        try {
            UserAction uAction = (UserAction)this.getValue();
            if (uAction.getActionListener() != null) {
                this.button.addActionListener(uAction.getActionListener());
            }
            this.button.setEnabled(uAction.getEnabled());
        }
        catch (Exception e) {
            logger.error("Can't initialize UserAction tunable: ", (Throwable)e);
        }
        GUIDefaults.updateFieldPanel(this.panel, this.button, this.horizontal);
        GUIDefaults.setTooltip(this.getTooltip(), this.button);
    }

    public void update() {
        try {
            UserAction uAction = (UserAction)this.getValue();
            this.button.setEnabled(uAction.getEnabled());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handle() {
    }

    public String getState() {
        return "";
    }
}

