/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.cytoscape.work.internal.tunables.utils.ViewUtil;

public class JComboBoxDecorator {
    static List<?> previousEntries = new ArrayList();

    public static void decorate(final JComboBox<?> jcb, final List<?> entries, final boolean begins) {
        Object selectedItem = jcb.getSelectedItem();
        jcb.setEditable(true);
        final JTextField textField = (JTextField)jcb.getEditor().getEditorComponent();
        jcb.setSelectedItem(selectedItem);
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ViewUtil.invokeOnEDT(() -> {
                    int currentCaretPosition = textField.getCaretPosition();
                    JComboBoxDecorator.comboFilter(textField.getText(), jcb, entries, begins);
                    textField.setCaretPosition(currentCaretPosition);
                });
            }
        });
    }

    private static void comboFilter(String enteredText, JComboBox<?> jcb, List<?> entries, boolean begins) {
        ArrayList entriesFiltered = new ArrayList();
        boolean changed = true;
        DefaultComboBoxModel jcbModel = (DefaultComboBoxModel)jcb.getModel();
        if (enteredText == null) {
            return;
        }
        for (Object entry : entries) {
            if (begins) {
                if (!entry.toString().toLowerCase().startsWith(enteredText.toLowerCase())) continue;
                entriesFiltered.add(entry);
                continue;
            }
            if (!entry.toString().toLowerCase().contains(enteredText.toLowerCase())) continue;
            entriesFiltered.add(entry);
        }
        if (previousEntries.size() == entriesFiltered.size() && previousEntries.containsAll(entriesFiltered)) {
            changed = false;
        }
        if (changed && entriesFiltered.size() > 1) {
            previousEntries = entriesFiltered;
            jcb.setModel(new DefaultComboBoxModel<Object>(entriesFiltered.toArray()));
            jcb.setSelectedItem(enteredText);
            jcb.showPopup();
        } else if (entriesFiltered.size() == 1) {
            if (entriesFiltered.get(0).toString().equalsIgnoreCase(enteredText)) {
                previousEntries = new ArrayList();
                jcb.setSelectedItem(entriesFiltered.get(0));
                jcb.hidePopup();
            } else {
                previousEntries = entriesFiltered;
                jcb.setModel(new DefaultComboBoxModel<Object>(entriesFiltered.toArray()));
                jcb.setSelectedItem(enteredText);
                jcb.showPopup();
            }
        } else if (entriesFiltered.size() == 0) {
            previousEntries = new ArrayList();
            jcb.hidePopup();
        }
    }
}

