/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.DataCategory;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.internal.tunables.utils.SupportedFileTypesManager;
import org.cytoscape.work.swing.AbstractGUITunableHandler;
import org.cytoscape.work.swing.DirectlyPresentableTunableHandler;

public class FileHandler
extends AbstractGUITunableHandler
implements DirectlyPresentableTunableHandler,
FocusListener {
    private final CyServiceRegistrar serviceRegistrar;
    private JPanel controlPanel;
    private JButton browseButton;
    private JTextField textField;
    private JLabel label;
    private SupportedFileTypesManager fileTypesManager;
    private boolean input;
    private List<FileChooserFilter> filters;
    private Window possibleParent;

    public FileHandler(Field field, Object obj, Tunable t, SupportedFileTypesManager fileTypesManager, CyServiceRegistrar serviceRegistrar) {
        super(field, obj, t);
        this.fileTypesManager = fileTypesManager;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    public FileHandler(Method getter, Method setter, Object instance, Tunable tunable, SupportedFileTypesManager fileTypesManager, CyServiceRegistrar serviceRegistrar) {
        super(getter, setter, instance, tunable);
        this.fileTypesManager = fileTypesManager;
        this.serviceRegistrar = serviceRegistrar;
        this.init();
    }

    private void init() {
        this.input = this.isInput();
        String fileCategory = this.getFileCategory();
        DataCategory dataCategory = DataCategory.valueOf((String)fileCategory.toUpperCase());
        this.filters = this.fileTypesManager.getSupportedFileTypes(dataCategory, this.input);
        this.setGui();
        GUIDefaults.updateFieldPanel(this.panel, this.label, (Component)this.controlPanel, this.horizontal);
        GUIDefaults.setTooltip(this.getTooltip(), this.textField, this.browseButton);
    }

    public void handle() {
        try {
            if (this.textField.getText().isEmpty()) {
                this.setValue(null);
            } else {
                String path = this.textField.getText();
                File file = null;
                if (path.contains(System.getProperty("file.separator"))) {
                    file = new File(path);
                } else {
                    CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
                    file = new File(applicationManager.getCurrentDirectory(), path);
                    this.textField.setText(file.getAbsolutePath());
                }
                this.setValue(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        File file = null;
        try {
            file = (File)this.getValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.textField.setText(file != null ? file.getAbsolutePath() : "");
    }

    private void setGui() {
        this.label = new JLabel();
        this.textField = new JTextField();
        this.textField.addFocusListener(this);
        IconManager iconManager = (IconManager)this.serviceRegistrar.getService(IconManager.class);
        TextIcon inputIcon = new TextIcon("\uf07c", iconManager.getIconFont(16.0f), 16, 16);
        this.browseButton = new JButton(this.input ? "Open File..." : "Browse...", (Icon)(this.input ? inputIcon : null));
        this.browseButton.setActionCommand(this.input ? "open" : "save");
        this.browseButton.addActionListener(new MyFileActionListener());
        if (this.input) {
            this.browseButton.setPreferredSize(new Dimension(this.browseButton.getPreferredSize().width, new JButton((String)"X").getPreferredSize().height));
        }
        String fileCategory = this.getFileCategory();
        String description = this.getDescription();
        if (description == null || description.isEmpty()) {
            this.label.setText((this.input ? "Load " : "Save ") + this.initialCaps(fileCategory) + " File");
        } else {
            this.label.setText(description);
        }
        try {
            File file = (File)this.getValue();
            if (file != null) {
                this.textField.setText(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.controlPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.textField, -1, 400, Short.MAX_VALUE).addComponent(this.browseButton, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.textField, -2, -1, -2).addComponent(this.browseButton, -2, -1, -2));
        int lh = this.label.getPreferredSize().height;
        int ch = this.controlPanel.getPreferredSize().height;
        if (lh < ch) {
            this.label.setBorder(BorderFactory.createEmptyBorder((ch - lh) / 2, 0, (ch - lh) / 2, 0));
        }
    }

    private String getFileCategory() {
        return this.getParams().getProperty("fileCategory", "unspecified");
    }

    private boolean isInput() {
        return this.getParams().getProperty("input", "false").equalsIgnoreCase("true");
    }

    private String initialCaps(String s) {
        if (s.isEmpty()) {
            return "";
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
    }

    public boolean isForcedToSetDirectly() {
        return this.getParams().getProperty("ForceSetDirectly", "true").equalsIgnoreCase("true");
    }

    public boolean setTunableDirectly(Window possibleParent) {
        this.possibleParent = possibleParent;
        this.setGui();
        MyFileActionListener action = new MyFileActionListener();
        action.actionPerformed(null);
        this.handle();
        return !this.textField.getText().equals("");
    }

    public String getState() {
        try {
            return this.textField.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.handle();
    }

    private final class MyFileActionListener
    implements ActionListener {
        private MyFileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FileUtil fileUtil;
            File file;
            Window parentComponent;
            int loadOrSave;
            int n = loadOrSave = FileHandler.this.input ? 0 : 1;
            if (loadOrSave == 1) {
                FileChooserFilter filter = null;
                for (int i = 0; i < FileHandler.this.filters.size(); ++i) {
                    filter = FileHandler.this.filters.get(i);
                    if (!filter.getDescription().trim().equalsIgnoreCase("All image files") && !filter.getDescription().trim().equalsIgnoreCase("All network files")) continue;
                    FileHandler.this.filters = new ArrayList<FileChooserFilter>();
                    FileHandler.this.filters.add(filter);
                    break;
                }
            }
            if ((parentComponent = SwingUtilities.getWindowAncestor(FileHandler.this.panel)) == null) {
                parentComponent = FileHandler.this.possibleParent;
            }
            if ((file = (fileUtil = (FileUtil)FileHandler.this.serviceRegistrar.getService(FileUtil.class)).getFile((Component)parentComponent, FileHandler.this.label.getText(), loadOrSave, FileHandler.this.filters)) != null) {
                FileHandler.this.textField.setText(file.getAbsolutePath());
            }
            FileHandler.this.handle();
        }
    }
}

