/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.tunables;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.swing.AbstractGUITunableHandler;

public abstract class AbstractNumberHandler
extends AbstractGUITunableHandler
implements FocusListener {
    private JTextField textField;
    private DecimalFormat format;
    private boolean isUpdating = false;

    public AbstractNumberHandler(Field f, Object o, Tunable t) {
        super(f, o, t);
        this.init();
    }

    public AbstractNumberHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private void init() {
        this.format = null;
        if (this.getFormat() != null && this.getFormat().length() > 0) {
            this.format = new DecimalFormat(this.getFormat());
        }
        Number d = null;
        try {
            d = this.getNumberValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            d = 0.0;
        }
        if (this.format == null) {
            double dx = d.doubleValue();
            this.format = dx > 1000000.0 || dx < 0.001 ? new DecimalFormat("0.#####E0") : new DecimalFormat();
        }
        this.format.setGroupingUsed(false);
        DocumentFilter filter = new DocumentFilter(){

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                Document doc = fb.getDocument();
                StringBuilder sb = new StringBuilder();
                sb.append(doc.getText(0, doc.getLength()));
                sb.delete(offset, offset + length);
                if (!AbstractNumberHandler.this.isUpdating && !AbstractNumberHandler.this.setValueFromText(sb.toString())) {
                    return;
                }
                super.remove(fb, offset, length);
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                Document doc = fb.getDocument();
                StringBuilder sb = new StringBuilder();
                sb.append(doc.getText(0, doc.getLength()));
                sb.insert(offset, string);
                if (!AbstractNumberHandler.this.isUpdating && !AbstractNumberHandler.this.setValueFromText(sb.toString())) {
                    return;
                }
                super.insertString(fb, offset, string, attr);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int i, int i1, String string, AttributeSet as) throws BadLocationException {
                Document doc = fb.getDocument();
                StringBuilder sb = new StringBuilder();
                sb.append(doc.getText(0, doc.getLength()));
                sb.replace(i, i + i1, string);
                if (!AbstractNumberHandler.this.isUpdating && !AbstractNumberHandler.this.setValueFromText(sb.toString())) {
                    return;
                }
                super.replace(fb, i, i1, string, as);
            }
        };
        this.textField = new JTextField(this.format.format(d));
        this.textField.setPreferredSize(new Dimension(150, this.textField.getPreferredSize().height));
        this.textField.setHorizontalAlignment(4);
        this.textField.addFocusListener(this);
        ((AbstractDocument)this.textField.getDocument()).setDocumentFilter(filter);
        JLabel label = new JLabel(this.getDescription());
        GUIDefaults.updateFieldPanel(this.panel, label, (Component)this.textField, this.horizontal);
        GUIDefaults.setTooltip(this.getTooltip(), label, this.textField);
    }

    public void update() {
        this.isUpdating = true;
        try {
            Number d = this.getNumberValue();
            this.textField.setText(this.format.format(d));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isUpdating = false;
    }

    public void handle() {
    }

    private boolean setValueFromText(String text) {
        Number d;
        block7: {
            d = null;
            try {
                d = this.getFieldValue(text);
            }
            catch (NumberFormatException nfe) {
                ParsePosition pos = new ParsePosition(0);
                d = this.format.parse(text, pos);
                if (d != null && !text.endsWith(".") && (text.length() == pos.getIndex() || text.substring(pos.getIndex()).equals("E") || text.substring(pos.getIndex()).equals("E-"))) break block7;
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
        }
        try {
            d = this.getTypedValue(d);
        }
        catch (NumberFormatException nfe) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        try {
            this.setValue(d);
        }
        catch (InvocationTargetException e) {
            JOptionPane.showMessageDialog(null, e.getTargetException().getMessage(), "Error", 0);
            return false;
        }
        catch (IllegalAccessException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            return false;
        }
        return true;
    }

    public abstract Number getFieldValue(String var1);

    public abstract Number getTypedValue(Number var1);

    public String getState() {
        if (this.textField == null) {
            return "";
        }
        String text = this.textField.getText();
        if (text == null) {
            return "";
        }
        return text;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.update();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    private Number getNumberValue() {
        try {
            return (Number)this.getValue();
        }
        catch (Exception e) {
            return new Double(0.0);
        }
    }
}

