/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.internal.task;

import java.awt.Window;
import java.util.concurrent.ExecutorService;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.internal.task.TaskHistory;
import org.cytoscape.work.internal.tunables.utils.GUIDefaults;
import org.cytoscape.work.internal.tunables.utils.ViewUtil;
import org.cytoscape.work.internal.view.TaskDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwingTaskMonitor
implements TaskMonitor {
    private static final String LOG_PREFIX = "TaskMonitor";
    private final ExecutorService cancelExecutorService;
    private final Window parent;
    private final TaskHistory.History history;
    private final CyServiceRegistrar serviceRegistrar;
    private volatile boolean cancelled;
    private volatile TaskDialog dialog;
    private volatile Task task;
    private volatile String firstTitle;
    private volatile String title;
    private volatile TaskMonitor.Level statusMessageLevel;
    private volatile String statusMessage;
    private volatile double progress;
    private volatile Exception exception;
    private int expectedNumTasks = 1;
    private int currentTaskNum = -1;
    private volatile boolean showDialog = true;
    private double fractionOfOverall = 1.0;
    Logger thisLog = null;

    public SwingTaskMonitor(ExecutorService cancelExecutorService, Window parent, TaskHistory.History history, CyServiceRegistrar serviceRegistrar) {
        this.cancelExecutorService = cancelExecutorService;
        this.parent = parent;
        this.history = history;
        this.serviceRegistrar = serviceRegistrar;
        this.thisLog = LoggerFactory.getLogger((String)LOG_PREFIX);
    }

    public void setExpectedNumTasks(int expectedNumTasks) {
        this.expectedNumTasks = expectedNumTasks;
        this.fractionOfOverall = 1.0 / (double)expectedNumTasks;
    }

    public void setTask(Task newTask) {
        ++this.currentTaskNum;
        this.task = newTask;
        this.thisLog = LoggerFactory.getLogger((String)("TaskMonitor." + newTask.getClass().getName()));
    }

    public void open() {
        ViewUtil.invokeOnEDT(() -> {
            SwingTaskMonitor swingTaskMonitor = this;
            synchronized (swingTaskMonitor) {
                if (this.dialog != null) {
                    return;
                }
                this.dialog = new TaskDialog(this.parent, this.serviceRegistrar);
                this.dialog.addPropertyChangeListener("task-close-event", evt -> this.close());
                this.dialog.addPropertyChangeListener("task-cancel-event", evt -> this.cancel());
                if (this.firstTitle != null && this.firstTitle != this.title) {
                    this.dialog.setTaskTitle(this.firstTitle);
                }
                if (this.title != null) {
                    this.dialog.setTaskTitle(this.title);
                }
                if (this.exception == null) {
                    if (this.statusMessage != null) {
                        if (this.statusMessageLevel == null) {
                            this.dialog.setStatus(null, null, this.statusMessage);
                        } else {
                            this.dialog.setStatus(GUIDefaults.getIconText(this.statusMessageLevel), GUIDefaults.getForeground(this.statusMessageLevel), this.statusMessage);
                        }
                    }
                    if (this.progress != 0.0) {
                        this.dialog.setPercentCompleted((float)this.progress);
                    }
                } else {
                    this.dialog.setException(this.exception);
                    this.exception = null;
                }
                this.dialog.setVisible(this.showDialog);
            }
        });
    }

    public void showDialog(boolean sd) {
        ViewUtil.invokeOnEDT(() -> {
            this.showDialog = sd;
            if (this.dialog != null && this.dialog.isVisible() != this.showDialog) {
                if (!this.showDialog) {
                    this.dialog.dispose();
                } else {
                    this.dialog.pack();
                    this.dialog.setVisible(true);
                }
            }
        });
    }

    public void close() {
        ViewUtil.invokeOnEDT(() -> {
            SwingTaskMonitor swingTaskMonitor = this;
            synchronized (swingTaskMonitor) {
                if (this.dialog != null) {
                    this.dialog.dispose();
                    this.dialog = null;
                }
                this.task = null;
            }
        });
    }

    public void cancel() {
        this.cancelled = true;
        Runnable cancel = () -> this.task.cancel();
        this.cancelExecutorService.submit(cancel);
    }

    protected boolean cancelled() {
        return this.cancelled;
    }

    public void setTitle(String title) {
        ViewUtil.invokeOnEDT(() -> {
            if (this.firstTitle == null) {
                this.firstTitle = title;
            }
            this.title = title;
            this.history.setTitle(title);
            if (this.dialog != null) {
                this.dialog.setTaskTitle(title);
            }
        });
    }

    public void setStatusMessage(String statusMessage) {
        this.showMessage(TaskMonitor.Level.INFO, statusMessage);
    }

    public void showMessage(TaskMonitor.Level level, String message) {
        switch (level) {
            case ERROR: {
                this.thisLog.error(message);
                break;
            }
            case WARN: {
                this.thisLog.warn(message);
                break;
            }
            case INFO: {
                this.thisLog.info(message);
            }
        }
        this.showStatusMessage(level, message);
    }

    public void setProgress(double newProgress) {
        ViewUtil.invokeOnEDT(() -> {
            if (newProgress < 0.0) {
                this.progress = -1.0;
                if (this.dialog != null) {
                    this.dialog.setPercentCompleted(-1.0f);
                }
            } else {
                this.progress = this.currentTaskNum < this.expectedNumTasks ? newProgress * this.fractionOfOverall + (double)this.currentTaskNum / (double)this.expectedNumTasks : newProgress;
                if (this.dialog != null) {
                    this.dialog.setPercentCompleted((float)this.progress);
                }
            }
        });
    }

    public void showException(Exception exception) {
        ViewUtil.invokeOnEDT(() -> {
            if (this.dialog == null) {
                this.exception = exception;
                this.open();
            } else {
                this.dialog.setException(exception);
            }
        });
    }

    public boolean isClosed() {
        return this.task == null;
    }

    private void showStatusMessage(TaskMonitor.Level level, String statusMessage) {
        ViewUtil.invokeOnEDT(() -> {
            this.statusMessage = statusMessage;
            this.statusMessageLevel = level;
            if (this.dialog != null) {
                this.dialog.setStatus(GUIDefaults.getIconText(this.statusMessageLevel), GUIDefaults.getForeground(this.statusMessageLevel), statusMessage);
            }
            this.history.addMessage(level, statusMessage);
        });
    }

    public String getFirstTitle() {
        return this.firstTitle;
    }
}

