/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.read.graphml;

public enum GraphMLToken {
    ID("id"),
    GRAPH("graph"),
    EDGEDEFAULT("edgedefault"),
    DIRECTED("directed"),
    UNDIRECTED("undirected"),
    KEY("key"),
    FOR("for"),
    ALL("all"),
    ATTRNAME("attr.name"),
    ATTRTYPE("attr.type"),
    DEFAULT("default"),
    NODE("node"),
    EDGE("edge"),
    DESC("desc"),
    SOURCE("source"),
    TARGET("target"),
    DATA("data"),
    TYPE("type"),
    INT("int", Integer.class),
    LONG("long", Long.class),
    FLOAT("float", Double.class),
    DOUBLE("double", Double.class),
    BOOLEAN("boolean", Boolean.class),
    STRING("string", String.class);

    private final String tag;
    final Class<?> dataType;

    private GraphMLToken(String tag) {
        this(tag, null);
    }

    private GraphMLToken(String tag, Class<?> dataType) {
        this.tag = tag;
        this.dataType = dataType;
    }

    public String getTag() {
        return this.tag;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public Object getObjectValue(String value) {
        if (this.dataType == String.class) {
            return value;
        }
        if (this.dataType == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (this.dataType == Integer.class) {
            return Integer.parseInt(value);
        }
        if (this.dataType == Long.class) {
            return Long.parseLong(value);
        }
        if (this.dataType == Float.class || this.dataType == Double.class) {
            return Double.parseDouble(value);
        }
        return null;
    }

    public static GraphMLToken getType(String tag) {
        for (GraphMLToken token : GraphMLToken.values()) {
            if (!token.getTag().equals(tag)) continue;
            return token;
        }
        return null;
    }
}

