/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.scripting.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.cytoscape.app.CyAppAdapter;
import org.cytoscape.scripting.internal.AbstractExecuteScriptTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.TaskMonitor;

public class ExecuteScriptCommandTask
extends AbstractExecuteScriptTask {
    private final String engineName;
    private final String filename;
    private final List<String> args;

    public ExecuteScriptCommandTask(ScriptEngineManager manager, String engineName, String filename, List<String> args, CyServiceRegistrar serviceRegistrar) {
        super(manager, serviceRegistrar);
        this.engineName = engineName;
        this.filename = filename;
        this.args = args == null ? new ArrayList<String>() : args;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        ScriptEngine engine = this.manager.getEngineByName(this.engineName);
        engine.put("cyAppAdapter", this.serviceRegistrar.getService(CyAppAdapter.class));
        String[] argArray = new String[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            System.out.println("* ARG = " + this.args.get(i));
            argArray[i] = this.args.get(i);
        }
        engine.put("args", argArray);
        InputStreamReader reader = null;
        try {
            reader = new FileReader(new File(this.filename));
            engine.eval(reader);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Could not open the file.", e);
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
    }
}

