/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.scripting.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.AbstractTask;

public abstract class AbstractExecuteScriptTask
extends AbstractTask {
    protected final Map<String, ScriptEngineFactory> name2engineMap;
    protected final CyServiceRegistrar serviceRegistrar;
    protected final List<String> engineNameList;
    protected final ScriptEngineManager manager;

    AbstractExecuteScriptTask(ScriptEngineManager manager, CyServiceRegistrar serviceRegistrar) {
        this.manager = manager;
        this.serviceRegistrar = serviceRegistrar;
        this.name2engineMap = new HashMap<String, ScriptEngineFactory>();
        List<ScriptEngineFactory> engines = manager.getEngineFactories();
        this.engineNameList = new ArrayList<String>();
        for (ScriptEngineFactory engine : engines) {
            String langName = engine.getLanguageName();
            String langVersion = engine.getLanguageVersion();
            String engineName = engine.getEngineName();
            String engineDescription = langName + " (" + engineName + ", Version " + langVersion + ")";
            this.engineNameList.add(engineDescription);
            this.name2engineMap.put(engineDescription, engine);
        }
        if (this.engineNameList.size() == 0) {
            throw new IllegalStateException("No Scripting Engine is available.");
        }
    }

    public void cancel() {
        Thread.currentThread().interrupt();
    }
}

