/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.cytoscape.file_transfer.internal.CyRESTAbstractTask;
import org.cytoscape.file_transfer.internal.SandboxUtils;
import org.cytoscape.file_transfer.internal.SetSandboxResult;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class SetSandboxTask
extends CyRESTAbstractTask {
    @Tunable(description="sandboxName", longDescription="Name of sandbox to create or reinitialize", exampleStringValue="mySandbox")
    public String sandboxName = "";
    @Tunable(description="copySamples", longDescription="Determines whether to copy Cytoscape's sampleData directory to the sandbox.", exampleStringValue="true")
    public boolean copySamples = true;
    @Tunable(description="reinitialize", longDescription="Determines whether existing files are erased from the sandbox.", exampleStringValue="true")
    public boolean reinitialize = true;
    private File sandboxParentDirFile;
    private File cytoscapeInstallDirFile;

    @ProvidesTitle
    public String getTitle() {
        return "Create a Cytoscape sandbox";
    }

    public SetSandboxTask(File sandboxParentDirFile, File cytoscapeInstallDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
        this.cytoscapeInstallDirFile = cytoscapeInstallDirFile;
    }

    public void run(TaskMonitor taskMon) throws Exception {
        File sandboxDirFile = SandboxUtils.getAbsSandboxFile(this.sandboxParentDirFile, this.sandboxName);
        if (this.reinitialize) {
            try {
                FileUtils.forceDelete((File)sandboxDirFile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        FileUtils.forceMkdir((File)sandboxDirFile);
        if (this.copySamples) {
            try {
                File samplesDirFile = new File(this.cytoscapeInstallDirFile, "sampleData");
                FileUtils.copyDirectoryToDirectory((File)samplesDirFile, (File)sandboxDirFile);
            }
            catch (Throwable e) {
                try {
                    FileUtils.forceDelete((File)sandboxDirFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
        this.result = new SetSandboxResult(sandboxDirFile.getCanonicalPath());
    }

    public static String getExample() {
        return SetSandboxTask.getJson(new SetSandboxResult("/User/CytoscapeConfiguration/FileTransfer/MySandbox"));
    }
}

