/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import org.cytoscape.file_transfer.internal.CyRESTAbstractTask;
import org.cytoscape.file_transfer.internal.GetFileInfoResult;
import org.cytoscape.file_transfer.internal.SandboxUtils;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class GetFileInfoTask
extends CyRESTAbstractTask {
    @Tunable(description="sandboxName", longDescription="Name of sandbox containing file", exampleStringValue="default_sandbox")
    public String sandboxName = "";
    @Tunable(description="fileName", longDescription="Sandbox-relative name of file or directory.", exampleStringValue="myFile.png")
    public String fileName = "";
    private File sandboxParentDirFile;

    @ProvidesTitle
    public String getTitle() {
        return "Return metadata for a sandboxed file or directory";
    }

    public GetFileInfoTask(File sandboxParentDirFile) {
        this.sandboxParentDirFile = sandboxParentDirFile;
    }

    public void run(TaskMonitor taskMon) throws Exception {
        File fileFile = SandboxUtils.getAbsFileFile(this.sandboxParentDirFile, this.sandboxName, this.fileName, true);
        String modifiedTime = SandboxUtils.getModifiedTime(fileFile);
        boolean isFile = modifiedTime.length() != 0 && fileFile.isFile();
        this.result = new GetFileInfoResult(fileFile.getCanonicalPath(), modifiedTime, isFile);
    }

    public static String getExample() {
        return GetFileInfoTask.getJson(new GetFileInfoResult("/User/CytoscapeConfiguration/FileTransfer/default_sandbox/MyFile.png", "2020-07-29 03:00:00.0000", true));
    }
}

