/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.File;
import java.util.Properties;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.file_transfer.internal.FromSandboxTask;
import org.cytoscape.file_transfer.internal.FromSandboxTaskFactory;
import org.cytoscape.file_transfer.internal.GetFileInfoTask;
import org.cytoscape.file_transfer.internal.GetFileInfoTaskFactory;
import org.cytoscape.file_transfer.internal.RemoveFileTask;
import org.cytoscape.file_transfer.internal.RemoveFileTaskFactory;
import org.cytoscape.file_transfer.internal.RemoveSandboxTask;
import org.cytoscape.file_transfer.internal.RemoveSandboxTaskFactory;
import org.cytoscape.file_transfer.internal.SetSandboxTask;
import org.cytoscape.file_transfer.internal.SetSandboxTaskFactory;
import org.cytoscape.file_transfer.internal.ToSandboxTask;
import org.cytoscape.file_transfer.internal.ToSandboxTaskFactory;
import org.cytoscape.file_transfer.internal.URLToSandboxTask;
import org.cytoscape.file_transfer.internal.URLToSandboxTaskFactory;
import org.cytoscape.service.util.AbstractCyActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class CyActivator
extends AbstractCyActivator {
    public static final String FILE_TRANSFER_COMMAND_NAMESPACE = "filetransfer";

    public void start(BundleContext bc) throws InvalidSyntaxException {
        CyApplicationConfiguration config = (CyApplicationConfiguration)this.getService(bc, CyApplicationConfiguration.class);
        File configDirFile = new File(config.getConfigurationDirectoryLocation().getAbsoluteFile(), FILE_TRANSFER_COMMAND_NAMESPACE);
        File installDirFile = config.getInstallationDirectoryLocation().getAbsoluteFile();
        Properties fromSandboxProperties = new Properties();
        fromSandboxProperties.setProperty("commandNamespace", FILE_TRANSFER_COMMAND_NAMESPACE);
        fromSandboxProperties.setProperty("command", "fromSandbox");
        fromSandboxProperties.setProperty("commandDescription", "Transfer a file from sandbox");
        fromSandboxProperties.setProperty("commandLongDescription", "Given a sandbox (as ```sandboxName```) and file within it (as ```fileName```), returns a Base64-encoded file image ```fileBase64```, the full file path ```filePath``` and a small amount of file metadata ```fileByteCount``` and ```modifiedTime```.");
        fromSandboxProperties.setProperty("commandExampleJSON", FromSandboxTask.getExample());
        fromSandboxProperties.setProperty("commandSupportsJSON", "true");
        FromSandboxTaskFactory fromSandboxTaskFactory = new FromSandboxTaskFactory(configDirFile);
        this.registerAllServices(bc, (Object)fromSandboxTaskFactory, fromSandboxProperties);
        Properties toSandboxProperties = new Properties();
        toSandboxProperties.setProperty("commandNamespace", FILE_TRANSFER_COMMAND_NAMESPACE);
        toSandboxProperties.setProperty("command", "toSandbox");
        toSandboxProperties.setProperty("commandDescription", "Transfer a file to sandbox");
        toSandboxProperties.setProperty("commandLongDescription", "Given a Base64-encoded file image ```fileBase64```, decode it, verify the size as ```fileByteCount```, and then write it to ```fileName``` in a sandbox (```sandboxName```). If the file already exists, it will be overwritten only if ```overwrite``` is true. Either way, return the file path (```filePath```).");
        toSandboxProperties.setProperty("commandExampleJSON", ToSandboxTask.getExample());
        toSandboxProperties.setProperty("commandSupportsJSON", "true");
        ToSandboxTaskFactory toSandboxTaskFactory = new ToSandboxTaskFactory(configDirFile);
        this.registerAllServices(bc, (Object)toSandboxTaskFactory, toSandboxProperties);
        Properties urlToSandboxProperties = new Properties();
        urlToSandboxProperties.setProperty("commandNamespace", FILE_TRANSFER_COMMAND_NAMESPACE);
        urlToSandboxProperties.setProperty("command", "urlToSandbox");
        urlToSandboxProperties.setProperty("commandDescription", "Transfer a URL-named file to sandbox");
        urlToSandboxProperties.setProperty("commandLongDescription", "Given a URL for a file, resolve it to an actual file, then download it and write it to ```fileName``` in a sandbox (```sandboxName```). If the file already exists, it will be overwritten only if ```overwrite``` is true. Either way, return the file path (```filePath```) and the count of bytes read.");
        urlToSandboxProperties.setProperty("commandExampleJSON", URLToSandboxTask.getExample());
        urlToSandboxProperties.setProperty("commandSupportsJSON", "true");
        URLToSandboxTaskFactory urlToSandboxTaskFactory = new URLToSandboxTaskFactory(configDirFile);
        this.registerAllServices(bc, (Object)urlToSandboxTaskFactory, urlToSandboxProperties);
        Properties setSandboxProperties = new Properties();
        setSandboxProperties.setProperty("commandNamespace", FILE_TRANSFER_COMMAND_NAMESPACE);
        setSandboxProperties.setProperty("command", "setSandbox");
        setSandboxProperties.setProperty("commandDescription", "Create a Cytoscape sandbox");
        setSandboxProperties.setProperty("commandLongDescription", "Given a sandbox name (as ```sandboxName```), create the sandbox if it doesn't exist. If it does exist, optionally clear it (```reinitialize```). Also, optionally add Cytoscape's sample files (```copySamples```). Either way, return the sandbox' full path (```sandboxPath```)");
        setSandboxProperties.setProperty("commandExampleJSON", SetSandboxTask.getExample());
        setSandboxProperties.setProperty("commandSupportsJSON", "true");
        SetSandboxTaskFactory setSandboxTaskFactory = new SetSandboxTaskFactory(configDirFile, installDirFile);
        this.registerAllServices(bc, (Object)setSandboxTaskFactory, setSandboxProperties);
        Properties removeSandboxProperties = new Properties();
        removeSandboxProperties.setProperty("commandNamespace", FILE_TRANSFER_COMMAND_NAMESPACE);
        removeSandboxProperties.setProperty("command", "removeSandbox");
        removeSandboxProperties.setProperty("commandDescription", "Remove a Cytoscape sandbox");
        removeSandboxProperties.setProperty("commandLongDescription", "Given a sandbox name (```sandboxName```), delete it and all its contents, then return the sandbox' full path (```sandboxPath```) and whether it existed (```existed```).");
        removeSandboxProperties.setProperty("commandExampleJSON", RemoveSandboxTask.getExample());
        removeSandboxProperties.setProperty("commandSupportsJSON", "true");
        RemoveSandboxTaskFactory removeSandboxTaskFactory = new RemoveSandboxTaskFactory(configDirFile);
        this.registerAllServices(bc, (Object)removeSandboxTaskFactory, removeSandboxProperties);
        Properties getFileInfoProperties = new Properties();
        getFileInfoProperties.setProperty("commandNamespace", FILE_TRANSFER_COMMAND_NAMESPACE);
        getFileInfoProperties.setProperty("command", "getFileInfo");
        getFileInfoProperties.setProperty("commandDescription", "Return metadata for a sandboxed file or directory");
        getFileInfoProperties.setProperty("commandLongDescription", "Given the sandbox (```sandboxName```) and file/directory name (```fileName```), returns the corresponding full path (```filePath```). If it doesn't exist, ```modifiedTime``` is returned empty. Otherwise, it contains the file system's modified time and whether the object is a file (```isFile```), too.");
        getFileInfoProperties.setProperty("commandExampleJSON", GetFileInfoTask.getExample());
        getFileInfoProperties.setProperty("commandSupportsJSON", "true");
        GetFileInfoTaskFactory getFileInfoTaskFactory = new GetFileInfoTaskFactory(configDirFile);
        this.registerAllServices(bc, (Object)getFileInfoTaskFactory, getFileInfoProperties);
        Properties removeFileProperties = new Properties();
        removeFileProperties.setProperty("commandNamespace", FILE_TRANSFER_COMMAND_NAMESPACE);
        removeFileProperties.setProperty("command", "removeFile");
        removeFileProperties.setProperty("commandDescription", "Remove a sandboxed file or directory");
        removeFileProperties.setProperty("commandLongDescription", "Given the sandbox (```sandboxName```) and file name (```fileName```), removes the file (if it exists) and return the full path (```filePath```).");
        removeFileProperties.setProperty("commandExampleJSON", RemoveFileTask.getExample());
        removeFileProperties.setProperty("commandSupportsJSON", "true");
        RemoveFileTaskFactory removeFileTaskFactory = new RemoveFileTaskFactory(configDirFile);
        this.registerAllServices(bc, (Object)removeFileTaskFactory, removeFileProperties);
    }
}

