/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.file_transfer.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CloudURL {
    private URL workingURL;
    private Cloud workingCloud;
    Map<String, Cloud> cloudMap = Map.of("drive.google.com", new GoogleDriveCloud(), "onedrive.live.com", new MicrosoftOnedriveCloud(), "github.com", new GithubCloud(), "www.dropbox.com", new DropboxCloud());

    CloudURL(String rawURL) throws MalformedURLException {
        this.workingURL = new URL(rawURL);
        this.workingCloud = this.cloudMap.get(this.workingURL.getHost());
    }

    private URL createNewURL(String newHost, String newPath, String newQuery) throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
        if (newHost == null) {
            newHost = this.workingURL.getHost();
        }
        if (newPath == null) {
            newPath = this.workingURL.getPath();
        }
        if (newQuery == null && (newQuery = this.workingURL.getQuery()) != null) {
            newQuery = URLDecoder.decode(newQuery, StandardCharsets.UTF_8);
        }
        String protocol = this.workingURL.getProtocol();
        String userInfo = this.workingURL.getUserInfo();
        int port = this.workingURL.getPort();
        String ref = this.workingURL.getRef();
        return new URI(protocol, userInfo, newHost, port, newPath, newQuery, ref).toURL();
    }

    public URLType getURLType() {
        return this.workingCloud == null ? URLType.UNKNOWN : this.workingCloud.getURLType();
    }

    public URL directURL() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
        return this.workingCloud == null ? this.workingURL : this.workingCloud.directURL();
    }

    public long readFile(String outputFile) throws Exception {
        int BUFFER_BYTES = 0x100000;
        URL directURL = this.directURL();
        InputStream urlIS = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            try {
                urlIS = this.workingCloud == null ? directURL.openConnection().getInputStream() : this.workingCloud.getInputStream(directURL);
            }
            catch (Exception ex) {
                throw new Exception("Error opening URL " + directURL + ": " + ex, ex);
            }
            if (outputFile == null) {
                throw new Exception("Output file name cannot be null");
            }
            try {
                os = new BufferedOutputStream(Files.newOutputStream(Paths.get(outputFile, new String[0]), new OpenOption[0]), 0x100000);
            }
            catch (Exception ex) {
                throw new Exception("Error opening output file " + outputFile + ": " + ex, ex);
            }
            try {
                is = new BufferedInputStream(urlIS, 0x100000);
            }
            catch (Exception ex) {
                throw new Exception("Error openiong buffered URL for " + directURL + ": " + ex, ex);
            }
            try {
                long l = is.transferTo(os);
                return l;
            }
            catch (Exception ex) {
                throw new Exception("Error copying " + directURL + " to " + outputFile + ": " + ex, ex);
            }
        }
        finally {
            if (urlIS != null) {
                urlIS.close();
            }
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private static void tryURL(String url, URLType expectedType, String expectedURL, long expectedLength) {
        try {
            System.out.println("Working on " + url);
            CloudURL cloudURL = new CloudURL(url);
            URLType urlType = cloudURL.getURLType();
            String directURL = cloudURL.directURL().toString();
            if (urlType != expectedType) {
                throw new Exception("Expected type not found");
            }
            if (!directURL.equals(expectedURL)) {
                throw new Exception("Expected URL not found");
            }
            long length = cloudURL.readFile("output.dat");
            if (length != expectedLength) {
                throw new Exception("Expected length not read");
            }
            System.out.println("Finished");
        }
        catch (Throwable e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        CloudURL.tryURL("http://tpsoft.com/museum_images/IBM%20PC.JPG", URLType.UNKNOWN, "http://tpsoft.com/museum_images/IBM%20PC.JPG", 438233L);
        CloudURL.tryURL("https://www.dropbox.com/s/r15azh0xb53smu1/GDS112_full.soft?dl=0", URLType.DROPBOX, "https://dl.dropboxusercontent.com/s/r15azh0xb53smu1/GDS112_full.soft?dl=0", 5536880L);
        CloudURL.tryURL("https://www.dropbox.com/s/8wc8o897tsxewt1/BIOGRID-ORGANISM-Saccharomyces_cerevisiae-3.2.105.mitab?dl=0", URLType.DROPBOX, "https://dl.dropboxusercontent.com/s/8wc8o897tsxewt1/BIOGRID-ORGANISM-Saccharomyces_cerevisiae-3.2.105.mitab?dl=0", 166981992L);
        CloudURL.tryURL("https://github.com/cytoscape/file-transfer-app/blob/master/test_data/GDS112_full.soft", URLType.GITHUB, "https://raw.githubusercontent.com/cytoscape/file-transfer-app/master/test_data/GDS112_full.soft", 5536880L);
        CloudURL.tryURL("https://onedrive.live.com/embed?cid=C357475E90DD89C4&resid=C357475E90DD89C4%217207&authkey=ACEU5LrVtI_jWTU", URLType.MICROSOFT_ONEDRIVE, "https://onedrive.live.com/download?cid=C357475E90DD89C4&resid=C357475E90DD89C4!7207&authkey=ACEU5LrVtI_jWTU", 5536880L);
        CloudURL.tryURL("https://onedrive.live.com/embed?cid=C357475E90DD89C4&resid=C357475E90DD89C4%217208&authkey=ALtnboERjtOdRbQ", URLType.MICROSOFT_ONEDRIVE, "https://onedrive.live.com/download?cid=C357475E90DD89C4&resid=C357475E90DD89C4!7208&authkey=ALtnboERjtOdRbQ", 166981992L);
        CloudURL.tryURL("https://drive.google.com/file/d/12sJaKQQbesF10xsrbgiNtUcqCQYY1YI3/view?usp=sharing", URLType.GOOGLE_DRIVE, "https://drive.google.com/uc?export=download&id=12sJaKQQbesF10xsrbgiNtUcqCQYY1YI3", 5536880L);
        CloudURL.tryURL("https://drive.google.com/file/d/1ws0DAJJjKupB2-mb5cL-A_T7yEI01tBd/view?usp=sharing", URLType.GOOGLE_DRIVE, "https://drive.google.com/uc?export=download&id=1ws0DAJJjKupB2-mb5cL-A_T7yEI01tBd", 166981992L);
        System.out.println("Done");
    }

    protected abstract class Cloud {
        protected Cloud() {
        }

        protected abstract URLType getURLType();

        protected abstract URL directURL() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException;

        protected InputStream getInputStream(URL directURL) throws IOException, URISyntaxException {
            return directURL.openConnection().getInputStream();
        }
    }

    protected class DropboxCloud
    extends Cloud {
        static final String DOMAIN = "www.dropbox.com";

        protected DropboxCloud() {
        }

        @Override
        public URLType getURLType() {
            return URLType.DROPBOX;
        }

        @Override
        protected URL directURL() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
            return CloudURL.this.createNewURL("dl.dropboxusercontent.com", null, null);
        }
    }

    protected class GithubCloud
    extends Cloud {
        static final String DOMAIN = "github.com";

        protected GithubCloud() {
        }

        @Override
        public URLType getURLType() {
            return URLType.GITHUB;
        }

        @Override
        protected URL directURL() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
            String newPath = CloudURL.this.workingURL.getPath().replaceFirst("/blob/", "/");
            return CloudURL.this.createNewURL("raw.githubusercontent.com", newPath, null);
        }
    }

    protected class GoogleDriveCloud
    extends Cloud {
        static final String DOMAIN = "drive.google.com";

        protected GoogleDriveCloud() {
        }

        @Override
        public URLType getURLType() {
            return URLType.GOOGLE_DRIVE;
        }

        @Override
        protected URL directURL() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
            Matcher m = Pattern.compile("^/file/d/([^/]*)/view$").matcher(CloudURL.this.workingURL.getPath());
            if (!m.matches()) {
                throw new MalformedURLException();
            }
            return CloudURL.this.createNewURL(null, "/uc", "export=download&id=" + m.group(1));
        }

        @Override
        protected InputStream getInputStream(URL directURL) throws IOException, URISyntaxException {
            CookieHandler priorCoockieHandler = CookieHandler.getDefault();
            try {
                CookieManager cm = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
                CookieHandler.setDefault(cm);
                InputStream is = directURL.openConnection().getInputStream();
                Map<String, List<String>> cookieMap = cm.get(directURL.toURI(), new HashMap<String, List<String>>());
                String confirmToken = null;
                List<String> cookieList = cookieMap.get("Cookie");
                for (String cookie : cookieList) {
                    if (!cookie.startsWith("download_warning")) continue;
                    confirmToken = cookie.substring(cookie.indexOf(61) + 1);
                }
                if (confirmToken != null) {
                    directURL = new URL(String.valueOf(directURL.toString()) + "&confirm=" + confirmToken);
                    is = directURL.openConnection().getInputStream();
                }
                InputStream inputStream = is;
                return inputStream;
            }
            finally {
                CookieHandler.setDefault(priorCoockieHandler);
            }
        }
    }

    protected class MicrosoftOnedriveCloud
    extends Cloud {
        static final String DOMAIN = "onedrive.live.com";

        protected MicrosoftOnedriveCloud() {
        }

        @Override
        public URLType getURLType() {
            return URLType.MICROSOFT_ONEDRIVE;
        }

        @Override
        protected URL directURL() throws MalformedURLException, URISyntaxException, UnsupportedEncodingException {
            return CloudURL.this.createNewURL(null, "/download", null);
        }
    }

    public static enum URLType {
        UNKNOWN,
        GOOGLE_DRIVE,
        MICROSOFT_ONEDRIVE,
        GITHUB,
        DROPBOX;

    }
}

