/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.idmapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Species {
    Human("Human", "Homo sapiens"),
    Mouse("Mouse", "Mus musculus"),
    Rat("Rat", "Rattus norvegicus"),
    Frog("Frog", "Xenopus tropicalis"),
    Zebra_fish("Zebra fish", "Danio rerio"),
    Fruit_fly("Fruit fly", "Drosophila melanogaster"),
    Mosquito("Mosquito", "Anopheles gambiae"),
    Arabidopsis_thaliana("Arabidopsis thaliana", "Arabidopsis thaliana"),
    Yeast("Yeast", "Saccharomyces cerevisiae"),
    Escherichia_coli("E. coli", "Escherichia coli"),
    Tuberculosis("Tuberculosis", "Mycobacterium tuberculosis"),
    Worm("Worm", "Caenorhabditis elegans");

    private String name;
    private String latin;
    static Map<String, String> mapToCommon;
    static Map<String, String> mapToLatin;

    private Species(String commonName, String latinName) {
        this.name = commonName;
        this.latin = latinName;
    }

    public static void buildMaps() {
        if (mapToCommon == null) {
            mapToCommon = new HashMap<String, String>();
            mapToLatin = new HashMap<String, String>();
            for (Species spec : Species.values()) {
                mapToCommon.put(spec.latin, spec.name);
                mapToLatin.put(spec.name, spec.latin);
            }
        }
    }

    public String common() {
        return this.name;
    }

    public String latin() {
        return this.latin;
    }

    public String fullname() {
        return this.name + " (" + this.latin + ")";
    }

    public static Species lookup(String input) {
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        int idx = input.indexOf(" (");
        if (idx > 0) {
            input = input.substring(0, idx);
        }
        for (Species s : Species.values()) {
            if (s.toString().compareToIgnoreCase(input) != 0 && s.name.compareToIgnoreCase(input) != 0 && s.latin.compareToIgnoreCase(input) != 0) continue;
            return s;
        }
        return null;
    }

    public static String[] commonNames() {
        String[] names = new String[Species.values().length];
        int i = 0;
        for (Species spec : Species.values()) {
            names[i++] = spec.name;
        }
        return names;
    }

    public static String[] latinNames() {
        String[] latinnames = new String[Species.values().length];
        int i = 0;
        for (Species spec : Species.values()) {
            latinnames[i++] = spec.latin;
        }
        return latinnames;
    }

    public static String[] fullNameArray() {
        String[] fullNames = new String[Species.values().length];
        int i = 0;
        for (Species spec : Species.values()) {
            fullNames[i++] = spec.fullname();
        }
        return fullNames;
    }

    public static List<String> fullNames() {
        ArrayList<String> fullNames = new ArrayList<String>();
        for (Species spec : Species.values()) {
            fullNames.add(spec.fullname());
        }
        return fullNames;
    }

    public boolean equals(String other) {
        if (this.name.equals(other)) {
            return true;
        }
        if (this.latin.equals(other)) {
            return true;
        }
        if (this.fullname().equals(other)) {
            return true;
        }
        return this.toString().equals(other);
    }

    public boolean match(Species other) {
        if (other == null || other.name().trim().length() == 0) {
            return true;
        }
        return this.name.equals(other.name);
    }

    public boolean isHuman() {
        return this.match(Human);
    }

    public boolean isFly() {
        return this.match(Fruit_fly);
    }

    public boolean isYeast() {
        return this.match(Yeast);
    }

    public boolean isWorm() {
        return this.match(Worm);
    }

    public boolean isMouse() {
        return this.match(Mouse);
    }
}

