/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.ArrowAnnotation;
import org.cytoscape.view.presentation.annotations.BoundedTextAnnotation;
import org.cytoscape.view.presentation.annotations.GroupAnnotation;
import org.cytoscape.view.presentation.annotations.ImageAnnotation;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.annotations.TextAnnotation;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public class ClipboardImpl {
    private final CyNetworkView sourceView;
    private final Set<CyNode> nodes;
    private final Set<CyEdge> edges;
    private final Set<Annotation> annotations;
    private final Map<CyNode, Map<VisualProperty<?>, Object>> nodeBypass;
    private final Map<CyEdge, Map<VisualProperty<?>, Object>> edgeBypassMap;
    private boolean cutOperation;
    private final Map<CyNode, double[]> nodePositions;
    private final Map<Long, Integer> multiPasteOffset;
    private Map<CyIdentifiable, CyRow> oldSharedRowMap;
    private Map<CyIdentifiable, CyRow> oldLocalRowMap;
    private Map<CyIdentifiable, CyRow> oldHiddenRowMap;
    private Map<CyRow, Map<String, Object>> oldValueMap;
    private double xTopLeft;
    private double yTopLeft;
    private final List<AnnotationFactory<? extends Annotation>> annotationFactories;
    private final CyServiceRegistrar serviceRegistrar;

    public ClipboardImpl(CyNetworkView sourceView, Set<CyNode> nodes, Set<CyEdge> edges, boolean cut, VisualLexicon lexicon, List<AnnotationFactory<? extends Annotation>> annotationFactories, CyServiceRegistrar serviceRegistrar) {
        this(sourceView, nodes, edges, null, cut, lexicon, annotationFactories, serviceRegistrar);
    }

    public ClipboardImpl(CyNetworkView sourceView, Collection<CyNode> nodes, Collection<CyEdge> edges, Collection<Annotation> annotations, boolean cut, VisualLexicon lexicon, List<AnnotationFactory<? extends Annotation>> annotationFactories, CyServiceRegistrar serviceRegistrar) {
        this.sourceView = sourceView;
        this.nodes = nodes != null ? new HashSet<CyNode>(nodes) : Collections.emptySet();
        this.edges = edges != null ? new HashSet<CyEdge>(edges) : Collections.emptySet();
        this.annotations = annotations != null ? new HashSet<Annotation>(annotations) : Collections.emptySet();
        this.cutOperation = cut;
        this.serviceRegistrar = serviceRegistrar;
        this.annotationFactories = annotationFactories;
        this.oldSharedRowMap = new WeakHashMap<CyIdentifiable, CyRow>();
        this.oldLocalRowMap = new WeakHashMap<CyIdentifiable, CyRow>();
        this.oldHiddenRowMap = new WeakHashMap<CyIdentifiable, CyRow>();
        this.nodeBypass = new HashMap();
        this.edgeBypassMap = new HashMap();
        this.nodePositions = new HashMap<CyNode, double[]>();
        this.multiPasteOffset = new HashMap<Long, Integer>();
        this.oldValueMap = new WeakHashMap<CyRow, Map<String, Object>>();
        this.init(lexicon);
    }

    private void init(VisualLexicon lexicon) {
        CyNetwork sourceNetwork = (CyNetwork)this.sourceView.getModel();
        CyRootNetwork sourceRootNetwork = ((CySubNetwork)sourceNetwork).getRootNetwork();
        Collection nodeProps = lexicon.getAllDescendants(BasicVisualLexicon.NODE);
        Collection edgeProps = lexicon.getAllDescendants(BasicVisualLexicon.EDGE);
        double[] topLeft = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
        Consumer<View> updateTopLeft = nodeView -> {
            double x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            double w = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
            double h = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT);
            topLeft[0] = Math.min(topLeft[0], x - w * 0.5);
            topLeft[1] = Math.min(topLeft[1], y - h * 0.5);
        };
        for (CyNode node : this.nodes) {
            this.addRows((CyIdentifiable)node, sourceRootNetwork, sourceNetwork);
            View nodeView2 = this.sourceView.getNodeView(node);
            if (nodeView2 == null) continue;
            this.saveNodePosition((View<CyNode>)nodeView2);
            ClipboardImpl.saveLockedValues(nodeView2, nodeProps, this.nodeBypass);
            updateTopLeft.accept(nodeView2);
        }
        for (CyEdge edge : this.edges) {
            View nodeView3;
            this.addRows((CyIdentifiable)edge, sourceRootNetwork, sourceNetwork);
            View edgeView = this.sourceView.getEdgeView(edge);
            if (edgeView == null) continue;
            ClipboardImpl.saveLockedValues(edgeView, edgeProps, this.edgeBypassMap);
            CyNode src = ((CyEdge)edgeView.getModel()).getSource();
            CyNode tgt = ((CyEdge)edgeView.getModel()).getTarget();
            if (!this.nodes.contains(src)) {
                nodeView3 = this.sourceView.getNodeView(src);
                if (nodeView3 != null) {
                    this.saveNodePosition((View<CyNode>)nodeView3);
                    ClipboardImpl.saveLockedValues(nodeView3, nodeProps, this.nodeBypass);
                }
                updateTopLeft.accept(nodeView3);
            }
            if (this.nodes.contains(tgt)) continue;
            nodeView3 = this.sourceView.getNodeView(tgt);
            if (nodeView3 != null) {
                this.saveNodePosition((View<CyNode>)nodeView3);
                ClipboardImpl.saveLockedValues(nodeView3, nodeProps, this.nodeBypass);
            }
            updateTopLeft.accept(nodeView3);
        }
        for (Annotation annotation : this.annotations) {
            Rectangle2D bounds = annotation.getRotatedBounds();
            double x = bounds.getMinX();
            double y = bounds.getMinY();
            topLeft[0] = Math.min(topLeft[0], x);
            topLeft[1] = Math.min(topLeft[1], y);
        }
        if (!Double.isFinite(topLeft[0]) || !Double.isFinite(topLeft[1])) {
            topLeft[0] = 0.0;
            topLeft[1] = 0.0;
        }
        this.xTopLeft = topLeft[0];
        this.yTopLeft = topLeft[1];
    }

    public Set<CyNode> getNodes() {
        return this.nodes;
    }

    public Set<CyEdge> getEdges() {
        return this.edges;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean clipboardHasData() {
        return !this.nodes.isEmpty() || !this.edges.isEmpty() || !this.annotations.isEmpty();
    }

    public Collection<CyIdentifiable> paste(CyNetworkView targetView, double x, double y) {
        LinkedHashSet<CyIdentifiable> pastedObjects = new LinkedHashSet<CyIdentifiable>();
        HashMap<CyRow, CyRow> rowMap = new HashMap<CyRow, CyRow>();
        HashMap<CyNode, CyNode> newNodeMap = new HashMap<CyNode, CyNode>();
        for (CyNode cyNode : this.nodes) {
            CyNode newNode = this.pasteNode(this.sourceView, targetView, cyNode, rowMap);
            newNodeMap.put(cyNode, newNode);
            pastedObjects.add((CyIdentifiable)newNode);
        }
        HashMap<CyEdge, CyEdge> newEdgeMap = new HashMap<CyEdge, CyEdge>();
        for (CyEdge edge : this.edges) {
            CyEdge newEdge = this.pasteEdge(this.sourceView, targetView, edge, rowMap, newNodeMap, pastedObjects);
            if (newEdge == null) continue;
            newEdgeMap.put(edge, newEdge);
            pastedObjects.add((CyIdentifiable)newEdge);
        }
        this.copyRows(rowMap);
        CyEventHelper cyEventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        cyEventHelper.flushPayloadEvents();
        targetView.updateView();
        int downwardShift = 10;
        int upwardShift = 50;
        int shiftTimes = this.multiPasteOffset.merge(targetView.getSUID(), 1, (a, b) -> a + 1);
        double xOffset = shiftTimes * 10;
        double yOffset = shiftTimes * 10;
        double centerx = (Double)targetView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
        double centery = (Double)targetView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
        double scale = (Double)targetView.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        double width = (Double)targetView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH);
        double height = (Double)targetView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT);
        double xMin = centerx - 0.5 * width / scale;
        double yMin = centery - 0.5 * height / scale;
        double xMax = centerx + 0.5 * width / scale;
        double yMax = centery + 0.5 * height / scale;
        if (this.yTopLeft + yOffset < yMin) {
            yOffset += yMin - this.yTopLeft;
        }
        if (this.xTopLeft + xOffset < xMin) {
            xOffset += xMin - this.xTopLeft;
        }
        if (this.yTopLeft > yMax) {
            yOffset = yMax - this.yTopLeft - 50.0;
        }
        if (this.xTopLeft > xMax) {
            xOffset = xMax - this.xTopLeft - 50.0;
        }
        for (CyNode node : this.nodePositions.keySet()) {
            CyNode newNode = newNodeMap.get(node);
            if (newNode == null || !pastedObjects.contains(newNode)) continue;
            double[] position = this.nodePositions.get(node);
            double nodeX = (position == null ? 0.0 : position[0]) + xOffset;
            double nodeY = (position == null ? 0.0 : position[1]) + yOffset;
            View newNodeView = targetView.getNodeView(newNode);
            if (newNodeView == null) continue;
            newNodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)nodeX);
            newNodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)nodeY);
            ClipboardImpl.setLockedValues(newNodeView, node, this.nodeBypass);
        }
        if (!this.edgeBypassMap.isEmpty()) {
            for (CyEdge edge : this.edgeBypassMap.keySet()) {
                CyEdge newEdge = (CyEdge)newEdgeMap.get(edge);
                View newEdgeView = newEdge != null ? targetView.getEdgeView(newEdge) : null;
                if (newEdgeView == null) continue;
                ClipboardImpl.setLockedValues(newEdgeView, edge, this.edgeBypassMap);
            }
        }
        for (CyIdentifiable object : pastedObjects) {
            if (!this.isSelected(targetView, object)) continue;
            this.reselect(targetView, object);
        }
        AnnotationManager annotationMgr = (AnnotationManager)this.serviceRegistrar.getService(AnnotationManager.class);
        HashMap<Annotation, Annotation> newAnnotationMap = new HashMap<Annotation, Annotation>();
        LinkedHashSet<ArrowAnnotation> arrowAnnotations = new LinkedHashSet<ArrowAnnotation>();
        for (Annotation a2 : this.annotations) {
            if (a2 instanceof ArrowAnnotation) {
                arrowAnnotations.add((ArrowAnnotation)a2);
                continue;
            }
            Annotation na = this.pasteAnnotation(targetView, annotationMgr, a2, xOffset, yOffset);
            if (na == null) continue;
            newAnnotationMap.put(a2, na);
        }
        for (ArrowAnnotation a3 : arrowAnnotations) {
            this.pasteArrowAnnotation(targetView, annotationMgr, a3, newAnnotationMap, newNodeMap, xOffset, yOffset);
        }
        return pastedObjects;
    }

    private CyEdge pasteEdge(CyNetworkView sourceView, CyNetworkView targetView, CyEdge edge, Map<CyRow, CyRow> rowMap, Map<CyNode, CyNode> newNodeMap, Collection<CyIdentifiable> pastedObjects) {
        CyNetwork sourceNetwork = (CyNetwork)sourceView.getModel();
        CyRootNetwork sourceRoot = ((CySubNetwork)sourceNetwork).getRootNetwork();
        CySubNetwork targetNetwork = (CySubNetwork)targetView.getModel();
        CyRootNetwork targetRoot = targetNetwork.getRootNetwork();
        CyEdge newEdge = null;
        CyNode sourceNode = edge.getSource();
        CyNode targetNode = edge.getTarget();
        if (sourceRoot != targetRoot) {
            CyNode newNode;
            if (!newNodeMap.containsKey(sourceNode)) {
                this.addRows((CyIdentifiable)sourceNode, sourceRoot, sourceNetwork);
                newNode = this.pasteNode(sourceView, targetView, sourceNode, rowMap);
                newNodeMap.put(sourceNode, newNode);
                pastedObjects.add((CyIdentifiable)newNode);
            }
            if (!newNodeMap.containsKey(targetNode)) {
                this.addRows((CyIdentifiable)targetNode, sourceRoot, sourceNetwork);
                newNode = this.pasteNode(sourceView, targetView, targetNode, rowMap);
                newNodeMap.put(targetNode, newNode);
                pastedObjects.add((CyIdentifiable)newNode);
            }
            newEdge = targetNetwork.addEdge(newNodeMap.get(sourceNode), newNodeMap.get(targetNode), edge.isDirected());
            rowMap.put(this.oldSharedRowMap.get(edge), targetNetwork.getRow((CyIdentifiable)newEdge, "USER"));
            rowMap.put(this.oldLocalRowMap.get(edge), targetNetwork.getRow((CyIdentifiable)newEdge, "LOCAL_ATTRS"));
            rowMap.put(this.oldHiddenRowMap.get(edge), targetNetwork.getRow((CyIdentifiable)newEdge, "HIDDEN"));
        } else {
            CyNode newNode;
            if (!newNodeMap.containsKey(sourceNode)) {
                if (targetNetwork.containsNode(sourceNode)) {
                    newNodeMap.put(sourceNode, sourceNode);
                } else {
                    this.addRows((CyIdentifiable)sourceNode, sourceRoot, sourceNetwork);
                    newNode = this.pasteNode(sourceView, targetView, sourceNode, rowMap);
                    newNodeMap.put(sourceNode, newNode);
                    pastedObjects.add((CyIdentifiable)newNode);
                }
            }
            if (!newNodeMap.containsKey(targetNode)) {
                if (targetNetwork.containsNode(targetNode)) {
                    newNodeMap.put(targetNode, targetNode);
                } else {
                    this.addRows((CyIdentifiable)targetNode, sourceRoot, sourceNetwork);
                    newNode = this.pasteNode(sourceView, targetView, targetNode, rowMap);
                    newNodeMap.put(targetNode, newNode);
                    pastedObjects.add((CyIdentifiable)newNode);
                }
            }
            if (targetNetwork.containsEdge(edge)) {
                newEdge = targetNetwork.addEdge(newNodeMap.get(sourceNode), newNodeMap.get(targetNode), edge.isDirected());
            } else {
                targetNetwork.addEdge(edge);
                newEdge = edge;
            }
            rowMap.put(this.oldLocalRowMap.get(edge), targetNetwork.getRow((CyIdentifiable)newEdge, "LOCAL_ATTRS"));
            rowMap.put(this.oldHiddenRowMap.get(edge), targetNetwork.getRow((CyIdentifiable)newEdge, "HIDDEN"));
        }
        return newEdge;
    }

    private CyNode pasteNode(CyNetworkView sourceView, CyNetworkView targetView, CyNode node, Map<CyRow, CyRow> rowMap) {
        CyNetwork sourceNetwork = (CyNetwork)sourceView.getModel();
        CyRootNetwork sourceRoot = ((CySubNetwork)sourceNetwork).getRootNetwork();
        CySubNetwork targetNetwork = (CySubNetwork)targetView.getModel();
        CyRootNetwork targetRoot = targetNetwork.getRootNetwork();
        CyNode newNode = null;
        if (sourceRoot != targetRoot) {
            newNode = targetNetwork.addNode();
            rowMap.put(this.oldSharedRowMap.get(node), targetNetwork.getRow((CyIdentifiable)newNode, "USER"));
            rowMap.put(this.oldLocalRowMap.get(node), targetNetwork.getRow((CyIdentifiable)newNode, "LOCAL_ATTRS"));
            rowMap.put(this.oldHiddenRowMap.get(node), targetNetwork.getRow((CyIdentifiable)newNode, "HIDDEN"));
        } else if (!targetNetwork.containsNode(node)) {
            targetNetwork.addNode(node);
            newNode = node;
            rowMap.put(this.oldLocalRowMap.get(node), targetNetwork.getRow((CyIdentifiable)newNode, "LOCAL_ATTRS"));
            rowMap.put(this.oldHiddenRowMap.get(node), targetNetwork.getRow((CyIdentifiable)newNode, "HIDDEN"));
        } else {
            newNode = targetNetwork.addNode();
            rowMap.put(this.oldHiddenRowMap.get(node), targetNetwork.getRow((CyIdentifiable)newNode, "HIDDEN"));
            rowMap.put(this.oldLocalRowMap.get(node), targetNetwork.getRow((CyIdentifiable)newNode, "LOCAL_ATTRS"));
        }
        return newNode;
    }

    private Annotation pasteAnnotation(CyNetworkView targetView, AnnotationManager annotationMgr, Annotation a, double xOffset, double yOffset) {
        Annotation na = this.cloneAnnotation(targetView, a, xOffset, yOffset);
        if (na != null) {
            annotationMgr.addAnnotation(na);
        }
        return na;
    }

    private ArrowAnnotation pasteArrowAnnotation(CyNetworkView targetView, AnnotationManager annotationMgr, ArrowAnnotation a, HashMap<Annotation, Annotation> newAnnotationMap, HashMap<CyNode, CyNode> newNodeMap, double xOffset, double yOffset) {
        Annotation na = this.cloneAnnotation(targetView, (Annotation)a, xOffset, yOffset);
        if (na instanceof ArrowAnnotation) {
            ArrowAnnotation newArrow = (ArrowAnnotation)na;
            Annotation src = a.getSource();
            if (src != null) {
                if (newAnnotationMap.containsKey(src)) {
                    src = newAnnotationMap.get(src);
                } else if (!targetView.equals(this.sourceView)) {
                    src = null;
                }
            }
            if (src == null) {
                return null;
            }
            newArrow.setSource(src);
            Object tgt = a.getTarget();
            if (tgt instanceof Annotation) {
                if (newAnnotationMap.containsKey(tgt)) {
                    tgt = newAnnotationMap.get(tgt);
                } else if (!targetView.equals(this.sourceView)) {
                    tgt = null;
                }
                newArrow.setTarget((Annotation)tgt);
            } else if (tgt instanceof View) {
                if (newNodeMap.containsKey(((View)tgt).getModel())) {
                    CyNode node = newNodeMap.get(((View)tgt).getModel());
                    tgt = targetView.getNodeView(node);
                } else if (!targetView.equals(this.sourceView)) {
                    CySubNetwork targetNetwork;
                    CyRootNetwork targetRoot;
                    CyNetwork sourceNetwork = (CyNetwork)this.sourceView.getModel();
                    CyRootNetwork sourceRoot = ((CySubNetwork)sourceNetwork).getRootNetwork();
                    if (sourceRoot.equals(targetRoot = (targetNetwork = (CySubNetwork)targetView.getModel()).getRootNetwork())) {
                        if (((View)tgt).getModel() instanceof CyNode) {
                            CyNode node = (CyNode)((View)tgt).getModel();
                            tgt = targetView.getNodeView(node);
                        } else {
                            tgt = null;
                        }
                    } else {
                        tgt = null;
                    }
                }
                newArrow.setTarget((View)tgt);
            } else if (tgt instanceof Point2D) {
                newArrow.setTarget((Point2D)tgt);
            }
            if (newArrow.getTarget() != null) {
                annotationMgr.addAnnotation((Annotation)newArrow);
                return newArrow;
            }
        }
        return null;
    }

    private void copyRows(Map<CyRow, CyRow> rowMap) {
        if (rowMap == null || rowMap.size() == 0) {
            return;
        }
        for (CyRow sourceRow : rowMap.keySet()) {
            CyRow targetRow = rowMap.get(sourceRow);
            CyTable destTable = targetRow.getTable();
            CyTable sourceTable = sourceRow.getTable();
            Map<String, Object> oldDataMap = this.oldValueMap.containsKey(sourceRow) ? this.oldValueMap.get(sourceRow) : sourceRow.getAllValues();
            for (String colName : oldDataMap.keySet()) {
                VirtualColumnInfo virtualInfo;
                CyColumn column = destTable.getColumn(colName);
                if (column == null) {
                    CyColumn sourceColumn = sourceTable.getColumn(colName);
                    if (sourceColumn.getType() == List.class) {
                        destTable.createListColumn(colName, sourceColumn.getListElementType(), sourceColumn.isImmutable());
                    } else {
                        destTable.createColumn(colName, sourceColumn.getType(), sourceColumn.isImmutable());
                    }
                } else if (column.isPrimaryKey() || (virtualInfo = column.getVirtualColumnInfo()).isVirtual() && !virtualInfo.getTargetJoinKey().equals("SUID")) continue;
                try {
                    targetRow.set(colName, oldDataMap.get(colName));
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Set failed!  " + e);
                }
            }
        }
    }

    public void addRows(CyIdentifiable object, CyRootNetwork sourceRootNetwork, CyNetwork sourceNetwork) {
        this.oldSharedRowMap.put(object, sourceRootNetwork.getRow(object, "SHARED_ATTRS"));
        CyRow localRow = sourceNetwork.getRow(object, "LOCAL_ATTRS");
        this.oldLocalRowMap.put(object, localRow);
        if (this.cutOperation) {
            this.oldValueMap.put(localRow, this.copyRowValues(localRow));
        }
        CyRow hiddenRow = sourceNetwork.getRow(object, "HIDDEN");
        this.oldHiddenRowMap.put(object, hiddenRow);
        if (this.cutOperation) {
            this.oldValueMap.put(hiddenRow, this.copyRowValues(hiddenRow));
        }
    }

    private Map<String, Object> copyRowValues(CyRow row) {
        return new HashMap<String, Object>(row.getAllValues());
    }

    private double[] saveNodePosition(View<CyNode> view) {
        if (view == null) {
            return null;
        }
        double x = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        double y = (Double)view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        double[] position = new double[]{x, y};
        this.nodePositions.put((CyNode)view.getModel(), position);
        return position;
    }

    private Annotation cloneAnnotation(CyNetworkView targetView, Annotation a, double xOffset, double yOffset) {
        HashMap<String, String> argMap = new HashMap<String, String>(a.getArgMap());
        argMap.remove("uuid");
        argMap.put("x", Double.toString(a.getX() + xOffset));
        argMap.put("y", Double.toString(a.getY() + yOffset));
        String type = (String)argMap.get("type");
        if (type == null) {
            return null;
        }
        if (type.equals("ARROW") || type.equals("org.cytoscape.view.presentation.annotations.ArrowAnnotation")) {
            return this.createAnnotation(ArrowAnnotation.class, targetView, argMap);
        }
        if (type.equals("SHAPE") || type.equals("org.cytoscape.view.presentation.annotations.ShapeAnnotation")) {
            return this.createAnnotation(ShapeAnnotation.class, targetView, argMap);
        }
        if (type.equals("TEXT") || type.equals("org.cytoscape.view.presentation.annotations.TextAnnotation")) {
            return this.createAnnotation(TextAnnotation.class, targetView, argMap);
        }
        if (type.equals("BOUNDEDTEXT") || type.equals("org.cytoscape.view.presentation.annotations.BoundedTextAnnotation")) {
            return this.createAnnotation(BoundedTextAnnotation.class, targetView, argMap);
        }
        if (type.equals("IMAGE") || type.equals("org.cytoscape.view.presentation.annotations.ImageAnnotation")) {
            return this.createAnnotation(ImageAnnotation.class, targetView, argMap);
        }
        if (type.equals("GROUP") || type.equals("org.cytoscape.view.presentation.annotations.GroupAnnotation")) {
            GroupAnnotation group = (GroupAnnotation)a;
            argMap.remove("memberUUIDs");
            GroupAnnotation newGroup = (GroupAnnotation)this.createAnnotation(GroupAnnotation.class, targetView, argMap);
            for (Annotation child : group.getMembers()) {
                Annotation newChild = this.cloneAnnotation(targetView, child, xOffset, yOffset);
                newGroup.addMember(newChild);
            }
            return newGroup;
        }
        return null;
    }

    public Annotation createAnnotation(Class type, CyNetworkView netView, Map<String, String> argMap) {
        for (AnnotationFactory<? extends Annotation> factory : this.annotationFactories) {
            Annotation a = factory.createAnnotation(type, netView, argMap);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    private boolean isSelected(CyNetworkView networkView, CyIdentifiable object) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        return Boolean.TRUE.equals(network.getRow(object).get("selected", Boolean.class));
    }

    private void reselect(CyNetworkView networkView, CyIdentifiable object) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        network.getRow(object).set("selected", (Object)false);
        network.getRow(object).set("selected", (Object)true);
    }

    static <T extends CyIdentifiable> void saveLockedValues(View<T> view, Collection<VisualProperty<?>> visualProps, Map<T, Map<VisualProperty<?>, Object>> bypassMap) {
        if (view == null) {
            return;
        }
        for (VisualProperty<?> vp : visualProps) {
            if (!view.isValueLocked(vp)) continue;
            Map<VisualProperty<?>, Object> vpMap = bypassMap.get(view.getModel());
            if (vpMap == null) {
                vpMap = new HashMap();
                bypassMap.put((CyIdentifiable)view.getModel(), vpMap);
            }
            vpMap.put(vp, view.getVisualProperty(vp));
        }
    }

    static <T extends CyIdentifiable> void setLockedValues(View<T> target, T orginalModel, Map<T, Map<VisualProperty<?>, Object>> bypassMap) {
        Map<VisualProperty<?>, Object> vpMap = bypassMap.get(orginalModel);
        if (vpMap != null) {
            for (Map.Entry<VisualProperty<?>, Object> entry : vpMap.entrySet()) {
                target.setLockedValue(entry.getKey(), entry.getValue());
            }
        }
    }
}

