/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.editor.internal;

import org.cytoscape.editor.internal.AddNestedNetworkTask;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNodeViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class AddNestedNetworkTaskFactory
extends AbstractNodeViewTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public AddNestedNetworkTaskFactory(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView networkView) {
        return new TaskIterator(new Task[]{new AddNestedNetworkTask(nodeView, networkView, this.serviceRegistrar)});
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView networkView) {
        if (!super.isReady(nodeView, networkView)) {
            return false;
        }
        CyNode node = (CyNode)nodeView.getModel();
        CyNetwork net = (CyNetwork)networkView.getModel();
        CyNetwork netPointer = node.getNetworkPointer();
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        CyGroupManager grMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        return netPointer == null || netMgr.networkExists(netPointer.getSUID().longValue()) && !grMgr.isGroup(node, net);
    }
}

