/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.util;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.work.util.ListSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListSingleSelection<T>
extends ListSelection<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private T selected;

    public ListSingleSelection(T ... values) {
        super(Arrays.asList(values));
        this.selected = this.values.isEmpty() ? null : this.values.get(0);
    }

    public ListSingleSelection(List<T> values) {
        super(values);
        this.selected = this.values.isEmpty() ? null : this.values.get(0);
    }

    public T getSelectedValue() {
        return this.selected;
    }

    public void setSelectedValue(T val) {
        if (!this.values.contains(val)) {
            logger.warn("value not contained in list of possible values possible items = " + Arrays.toString(this.getPossibleValues().toArray()));
        }
        if (val == null && this.selected != null || val != null && !val.equals(this.selected)) {
            this.selected = val;
            this.selectionChanged();
        }
    }
}

