/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.util;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.work.util.ListChangeListener;

public class ListSelection<T> {
    protected List<T> values;
    private List<ListChangeListener<T>> listeners = null;

    public ListSelection(List<T> values) {
        if (values == null) {
            throw new NullPointerException("values is null.");
        }
        this.values = values;
    }

    public void setPossibleValues(List<T> values) {
        if (values == null) {
            throw new NullPointerException("values is null.");
        }
        this.values = values;
        this.listChanged();
    }

    public List<T> getPossibleValues() {
        return new ArrayList<T>(this.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListChangeListener<T> changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListChangeListener<T>>();
        }
        List<ListChangeListener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ListChangeListener<T> changeListener) {
        if (this.listeners != null && this.listeners.contains(changeListener)) {
            List<ListChangeListener<T>> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }
    }

    public List<ListChangeListener<T>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListChangeListener<T>>();
        }
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listChanged() {
        if (this.listeners == null) {
            return;
        }
        List<ListChangeListener<T>> list = this.listeners;
        synchronized (list) {
            ArrayList<ListChangeListener<T>> l = new ArrayList<ListChangeListener<T>>(this.listeners);
            for (ListChangeListener listChangeListener : l) {
                listChangeListener.listChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectionChanged() {
        if (this.listeners == null) {
            return;
        }
        List<ListChangeListener<T>> list = this.listeners;
        synchronized (list) {
            ArrayList<ListChangeListener<T>> l = new ArrayList<ListChangeListener<T>>(this.listeners);
            for (ListChangeListener listChangeListener : l) {
                listChangeListener.selectionChanged(this);
            }
        }
    }
}

