/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.util;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.work.util.BoundedChangeListener;

public abstract class AbstractBounded<N extends Comparable<N>> {
    private N value;
    private N lower;
    private N upper;
    private boolean upperStrict;
    private boolean lowerStrict;
    private List<BoundedChangeListener<N>> listeners = null;

    public AbstractBounded(N lower, N initValue, N upper, boolean lowerStrict, boolean upperStrict) {
        if (lower == null) {
            throw new NullPointerException("lower bound is null.");
        }
        if (upper == null) {
            throw new NullPointerException("upper bound is null.");
        }
        if (lower.compareTo(upper) >= 0) {
            throw new IllegalArgumentException("lower value is greater than or equal to upper value");
        }
        this.lower = lower;
        this.upper = upper;
        this.lowerStrict = lowerStrict;
        this.upperStrict = upperStrict;
        this.setValue(initValue);
    }

    public N getUpperBound() {
        return this.upper;
    }

    public N getLowerBound() {
        return this.lower;
    }

    public boolean isUpperBoundStrict() {
        return this.upperStrict;
    }

    public boolean isLowerBoundStrict() {
        return this.lowerStrict;
    }

    public synchronized N getValue() {
        return this.value;
    }

    public void setUpperBoundStrict(boolean upperStrict) {
        this.upperStrict = upperStrict;
        this.value = this.clamp(this.value);
        this.boundsChanged();
    }

    public void setLowerBoundStrict(boolean lowerStrict) {
        this.lowerStrict = lowerStrict;
        this.value = this.clamp(this.value);
        this.boundsChanged();
    }

    public void setBounds(N lower, N upper) {
        if (upper == null) {
            throw new NullPointerException("Upper bound is null.");
        }
        if (upper.compareTo(lower) <= 0) {
            throw new IllegalArgumentException("Upper value is less than or equal to lower value");
        }
        if (lower.compareTo(upper) >= 0) {
            throw new IllegalArgumentException("Lower value is greater than or equal to upper value");
        }
        this.upper = upper;
        this.lower = lower;
        this.value = this.clamp(this.value);
        this.boundsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(N v) {
        if (v == null) {
            throw new NullPointerException("Value is null.");
        }
        AbstractBounded abstractBounded = this;
        synchronized (abstractBounded) {
            int up = v.compareTo(this.upper);
            if (this.upperStrict) {
                if (up >= 0) {
                    throw new IllegalArgumentException("Value is greater than or equal to upper limit");
                }
            } else if (up > 0) {
                throw new IllegalArgumentException("Value is greater than upper limit");
            }
            int low = v.compareTo(this.lower);
            if (this.lowerStrict) {
                if (low <= 0) {
                    throw new IllegalArgumentException("Value is less than or equal to lower limit");
                }
            } else if (low < 0) {
                throw new IllegalArgumentException("Value is less than lower limit");
            }
            this.value = v;
        }
        this.valueChanged();
    }

    public abstract void setValue(String var1);

    public abstract N clamp(N var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BoundedChangeListener<N> changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BoundedChangeListener<N>>();
        }
        List<BoundedChangeListener<N>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(BoundedChangeListener<N> changeListener) {
        if (this.listeners != null && this.listeners.contains(changeListener)) {
            List<BoundedChangeListener<N>> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }
    }

    public List<BoundedChangeListener<N>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BoundedChangeListener<N>>();
        }
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void boundsChanged() {
        if (this.listeners == null) {
            return;
        }
        List<BoundedChangeListener<N>> list = this.listeners;
        synchronized (list) {
            ArrayList<BoundedChangeListener<N>> l = new ArrayList<BoundedChangeListener<N>>(this.listeners);
            for (BoundedChangeListener boundedChangeListener : l) {
                boundedChangeListener.boundsChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valueChanged() {
        if (this.listeners == null) {
            return;
        }
        List<BoundedChangeListener<N>> list = this.listeners;
        synchronized (list) {
            ArrayList<BoundedChangeListener<N>> l = new ArrayList<BoundedChangeListener<N>>(this.listeners);
            for (BoundedChangeListener boundedChangeListener : l) {
                boundedChangeListener.valueChanged(this);
            }
        }
    }
}

