/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.work.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.cytoscape.work.AbstractTunableHandler;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.GUITunableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGUITunableHandler
extends AbstractTunableHandler
implements GUITunableHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    protected static final Font LABEL_FONT = UIManager.getFont("Label.font");
    protected boolean horizontal;
    protected JPanel panel;
    private String dependencyName;
    private String mustMatch;
    private String mustNotMatch;
    private List<GUITunableHandler> dependents;
    private List<GUITunableHandler> listeners;
    private boolean notifyingListeners = false;

    protected AbstractGUITunableHandler(Field field, Object instance, Tunable tunable) {
        super(field, instance, tunable);
        this.init();
    }

    protected AbstractGUITunableHandler(Method getter, Method setter, Object instance, Tunable tunable) {
        super(getter, setter, instance, tunable);
        this.init();
    }

    private void init() {
        String rawAlignments = this.getParams().getProperty("alignments", "vertical");
        this.horizontal = false;
        String[] alignments = rawAlignments.split(",");
        if (alignments[0].trim().equalsIgnoreCase("horizontal")) {
            this.horizontal = true;
        } else if (!alignments[0].trim().equalsIgnoreCase("vertical")) {
            logger.warn("\"alignments\" was specified but is neither \"horizontal\" nor \"vertical\".");
        }
        String s = this.dependsOn();
        if (!s.isEmpty()) {
            if (!s.contains("!=")) {
                this.dependencyName = s.substring(0, s.indexOf("="));
                this.mustMatch = s.substring(s.indexOf("=") + 1);
                this.mustNotMatch = "";
            } else {
                this.dependencyName = s.substring(0, s.indexOf("!"));
                this.mustNotMatch = s.substring(s.indexOf("=") + 1);
                this.mustMatch = "";
            }
        }
        this.dependents = new LinkedList<GUITunableHandler>();
        this.listeners = new LinkedList<GUITunableHandler>();
        this.panel = new TunableFieldPanel();
    }

    @Override
    public void setValue(Object newValue) throws IllegalAccessException, InvocationTargetException {
        super.setValue(newValue);
        this.notifyDependents();
        this.notifyChangeListeners();
    }

    @Override
    public void notifyDependents() {
        String state = this.getState();
        String name = this.getName();
        for (GUITunableHandler gh : this.dependents) {
            gh.checkDependency(name, state);
        }
    }

    @Override
    public void notifyChangeListeners() {
        String state = this.getState();
        String name = this.getName();
        for (GUITunableHandler gh : this.listeners) {
            this.notifyingListeners = true;
            gh.changeOccurred(name, state);
            this.notifyingListeners = false;
        }
    }

    @Override
    public void addChangeListener(GUITunableHandler gh) {
        if (!this.listeners.contains(gh)) {
            GUITunableHandler old;
            if (this.notifyingListeners && (old = this.getListenerFor(gh.getQualifiedName())) != null) {
                this.listeners = new LinkedList<GUITunableHandler>(this.listeners);
                this.listeners.remove(old);
            }
            this.listeners.add(gh);
        }
    }

    @Override
    public void addDependent(GUITunableHandler gh) {
        if (!this.dependents.contains(gh)) {
            this.dependents.add(gh);
        }
    }

    @Override
    public String getDependency() {
        return this.dependencyName;
    }

    @Override
    public String[] getChangeSources() {
        return this.listenForChange();
    }

    @Override
    public final void changeOccurred(String name, String state) {
        this.update();
    }

    @Override
    public final void checkDependency(String depName, String depState) {
        if (this.dependencyName == null || this.mustMatch == null) {
            this.setEnabledContainer(true, this.panel);
            return;
        }
        if (this.dependencyName.equals(depName)) {
            if (!this.mustMatch.isEmpty()) {
                if (this.mustMatch.equals(depState)) {
                    this.setEnabledContainer(true, this.panel);
                } else {
                    this.setEnabledContainer(false, this.panel);
                }
            } else if (!this.mustNotMatch.equals(depState)) {
                this.setEnabledContainer(true, this.panel);
            } else {
                this.setEnabledContainer(false, this.panel);
            }
        }
    }

    private void setEnabledContainer(boolean enable, Container container) {
        container.setEnabled(enable);
        for (Component child : container.getComponents()) {
            if (child instanceof Container) {
                this.setEnabledContainer(enable, (Container)child);
                continue;
            }
            child.setEnabled(enable);
        }
    }

    @Override
    public JPanel getJPanel() {
        return this.panel;
    }

    @Override
    public abstract void handle();

    @Override
    public void update() {
    }

    @Override
    public String getState() {
        try {
            Object value = this.getValue();
            return value == null ? "" : value.toString();
        }
        catch (Exception e) {
            logger.warn("Could not get state.", (Throwable)e);
            return "";
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    private GUITunableHandler getListenerFor(String tunable) {
        for (GUITunableHandler gh : this.listeners) {
            if (!gh.getQualifiedName().equals(tunable)) continue;
            return gh;
        }
        return null;
    }

    public final class TunableFieldPanel
    extends JPanel {
        private static final long serialVersionUID = 7445323343174359197L;
        private JLabel label;
        private JTextArea multiLineLabel;
        private Component control;

        public TunableFieldPanel() {
        }

        public TunableFieldPanel(JLabel label, Component control) {
            this.label = label;
            this.control = control;
            this.update();
        }

        public TunableFieldPanel(JTextArea multiLineLabel, Component control) {
            this.multiLineLabel = multiLineLabel;
            this.control = control;
            this.update();
        }

        public GUITunableHandler getTunableHandler() {
            return AbstractGUITunableHandler.this;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void setLabel(JLabel label) {
            this.label = label;
            this.update();
        }

        public JTextArea getMultiLineLabel() {
            return this.multiLineLabel;
        }

        public void setMultiLineLabel(JTextArea multiLineLabel) {
            this.multiLineLabel = multiLineLabel;
            this.update();
        }

        public Component getControl() {
            return this.control;
        }

        public void setControl(Component control) {
            this.control = control;
            this.update();
        }

        private void update() {
            GroupLayout.Alignment vAlign;
            JComponent lbl;
            Component c;
            this.removeAll();
            Component component = c = this.control != null ? this.control : new JLabel(" ");
            if (this.label != null) {
                this.label.setHorizontalAlignment(AbstractGUITunableHandler.this.horizontal ? 2 : 4);
                lbl = this.label;
            } else if (this.multiLineLabel != null) {
                this.multiLineLabel.setLineWrap(true);
                this.multiLineLabel.setWrapStyleWord(true);
                this.multiLineLabel.setOpaque(false);
                this.multiLineLabel.setBorder(null);
                this.multiLineLabel.setEditable(false);
                lbl = this.multiLineLabel;
            } else {
                lbl = new JLabel(" ");
            }
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            GroupLayout.Alignment alignment = vAlign = c instanceof JPanel || c instanceof JScrollPane ? GroupLayout.Alignment.LEADING : GroupLayout.Alignment.CENTER;
            if (AbstractGUITunableHandler.this.horizontal) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
                layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(lbl, -2, -1, -2).addComponent(c, -2, -1, -2));
                layout.setVerticalGroup(layout.createParallelGroup(vAlign, false).addComponent(lbl).addComponent(c));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(lbl)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(c, -2, -1, -2))));
                layout.setVerticalGroup(layout.createParallelGroup(vAlign, false).addComponent(lbl).addComponent(c));
            }
        }
    }
}

