/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.mappings;

import org.cytoscape.event.CyEventHelper;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangeRecord;
import org.cytoscape.view.vizmap.events.VisualMappingFunctionChangedEvent;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;

public final class ContinuousMappingPoint<K, V> {
    private K value;
    private BoundaryRangeValues<V> range;
    private final ContinuousMapping<K, V> parentMapping;
    private final CyEventHelper eventHelper;

    public ContinuousMappingPoint(K value, BoundaryRangeValues<V> range, ContinuousMapping<K, V> parentMapping, CyEventHelper eventHelper) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Value must be a number.");
        }
        this.value = value;
        this.range = range;
        this.parentMapping = parentMapping;
        this.eventHelper = eventHelper;
    }

    public K getValue() {
        return this.value;
    }

    public void setValue(K value) {
        K oldValue = this.value;
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.value = value;
            this.eventHelper.addEventPayload(this.parentMapping, new VisualMappingFunctionChangeRecord(), VisualMappingFunctionChangedEvent.class);
        }
    }

    public BoundaryRangeValues<V> getRange() {
        return this.range;
    }

    public void setRange(BoundaryRangeValues<V> range) {
        BoundaryRangeValues<V> oldRange = this.range;
        if (range == null && oldRange != null || range != null && !range.equals(oldRange)) {
            this.range = range;
            this.eventHelper.addEventPayload(this.parentMapping, new VisualMappingFunctionChangeRecord(), VisualMappingFunctionChangedEvent.class);
        }
    }
}

