/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.mappings;

import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;

public abstract class AbstractVisualMappingFunction<K, V>
implements VisualMappingFunction<K, V> {
    protected final String columnName;
    protected final Class<K> columnType;
    protected final VisualProperty<V> vp;
    protected final CyEventHelper eventHelper;

    public AbstractVisualMappingFunction(String columnName, Class<K> columnType, VisualProperty<V> vp, CyEventHelper eventHelper) {
        this.columnType = columnType;
        this.columnName = columnName;
        this.vp = vp;
        this.eventHelper = eventHelper;
    }

    @Override
    public String getMappingColumnName() {
        return this.columnName;
    }

    @Override
    public Class<K> getMappingColumnType() {
        return this.columnType;
    }

    @Override
    public VisualProperty<V> getVisualProperty() {
        return this.vp;
    }

    @Override
    public void apply(CyRow row, View<? extends CyIdentifiable> view) {
        Object value = this.getMappedValue(row);
        if (value != null) {
            view.setVisualProperty(this.vp, value);
        }
    }
}

