/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;

public final class VisualPropertyUtil {
    private VisualPropertyUtil() {
    }

    public static boolean isChildOf(VisualProperty<?> parent, VisualProperty<?> vp, VisualLexicon lexicon) {
        if (vp == null) {
            throw new NullPointerException("Visual Property is null.");
        }
        if (lexicon == null) {
            throw new NullPointerException("Lexicon is null.");
        }
        if (!lexicon.getAllVisualProperties().contains(vp)) {
            throw new IllegalArgumentException("No such Visual Porperty in the lexicon: " + vp.getDisplayName());
        }
        VisualLexiconNode node = lexicon.getVisualLexiconNode(vp);
        if (node.getParent() == null) {
            return false;
        }
        if (vp.equals(parent) || node.getParent().getVisualProperty().equals(parent)) {
            return true;
        }
        while (node.getParent() != null) {
            if ((node = node.getParent()).getVisualProperty() != parent) continue;
            return true;
        }
        return false;
    }
}

