/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaintVisualProperty
extends AbstractVisualProperty<Paint> {
    private static final Map<String, String> COLOR_MAP = new HashMap<String, String>();
    private static final String COLOR_CODE_RESOURCE = "cross_browser_color_code.txt";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public PaintVisualProperty(Paint def, Range<Paint> range, String id, String displayName, Class<? extends CyIdentifiable> modelDataType) {
        super(def, range, id, displayName, modelDataType);
    }

    @Override
    public String toSerializableString(Paint paint) {
        Color color;
        if (!(paint instanceof Color)) {
            logger.warn("None-Color object found.  Currently, this implementation supports only Color object.");
            color = Color.WHITE;
        } else {
            color = (Color)paint;
        }
        int rgb = color.getRGB();
        String hex = String.format("#%06X", 0xFFFFFF & rgb);
        return hex;
    }

    @Override
    public Paint parseSerializableString(String text) {
        if (text == null) {
            return null;
        }
        String string = text = COLOR_MAP.containsKey(text = text.trim().toUpperCase()) ? COLOR_MAP.get(text) : text;
        if (text.startsWith("#")) {
            try {
                return Color.decode(text);
            }
            catch (NumberFormatException e) {
                logger.error("Invalid hex RGB format: " + text, (Throwable)e);
                return null;
            }
        }
        String s = text.replaceAll("(?i)rgb *\\(", "").replaceAll("\\)", "");
        StringTokenizer strtok = new StringTokenizer(s, ",");
        if (strtok.countTokens() != 3) {
            logger.error("Not all RGB integers specified: " + text);
            return null;
        }
        String red = strtok.nextToken().trim();
        String green = strtok.nextToken().trim();
        String blue = strtok.nextToken().trim();
        try {
            int r = Integer.parseInt(red);
            int g = Integer.parseInt(green);
            int b = Integer.parseInt(blue);
            return new Color(r, g, b);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid hex RGB format: " + text, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void buildColorCodeTable(URL resourceURL) {
        BufferedReader bufRd = null;
        try {
            String line;
            bufRd = new BufferedReader(new InputStreamReader(resourceURL.openStream()));
            while ((line = bufRd.readLine()) != null) {
                String[] parts = line.split("\\t");
                COLOR_MAP.put(parts[0].trim().toUpperCase(), parts[1].trim());
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (bufRd != null) {
                try {
                    try {
                        bufRd.close();
                        bufRd = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        bufRd = null;
                    }
                }
                catch (Throwable throwable) {
                    bufRd = null;
                    throw throwable;
                }
            }
        }
    }

    static {
        PaintVisualProperty.buildColorCodeTable(PaintVisualProperty.class.getClassLoader().getResource(COLOR_CODE_RESOURCE));
    }
}

