/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.presentation.property;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.view.model.AbstractVisualProperty;
import org.cytoscape.view.model.DiscreteRange;
import org.cytoscape.view.model.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontVisualProperty
extends AbstractVisualProperty<Font> {
    private static final Logger logger;
    private static final Range<Font> FONT_RANGE;
    private static final int DEF_FONT_SIZE = 12;
    private static final Font DEFAULT_FONT;
    private static final Pattern CY2_FONT_PATTERN;
    private static final Pattern FONT_PATTERN;
    private static final Pattern FONT_BOLD_PATTERN;
    private static final Pattern FONT_SIZE_PATTERN;
    private static final String EMPTY_STRING = "";

    public FontVisualProperty(Font def, String id, String displayName, Class<? extends CyIdentifiable> modelDataType) {
        super(def, FONT_RANGE, id, displayName, modelDataType);
    }

    @Override
    public String toSerializableString(Font value) {
        String name = value.getFontName();
        String weight = value.isBold() ? "bold" : "plain";
        int size = value.getSize();
        return name + "," + weight + "," + size;
    }

    @Override
    public Font parseSerializableString(String text) {
        if (text != null && text.trim().length() != 0) {
            Matcher matcher = CY2_FONT_PATTERN.matcher(text);
            if (matcher.matches()) {
                return this.parseCy2Font(matcher.group(1), matcher.group(2), matcher.group(3));
            }
            return this.parseFont(text);
        }
        return DEFAULT_FONT;
    }

    private final Font parseFont(String text) {
        Matcher m1 = FONT_PATTERN.matcher(text);
        String name = m1.replaceAll(EMPTY_STRING);
        Matcher boldMatcher = FONT_BOLD_PATTERN.matcher(text);
        boolean bold = boldMatcher.matches();
        int style = bold ? 1 : 0;
        int size = 12;
        Matcher sizeMatcher = FONT_SIZE_PATTERN.matcher(text);
        String sSize = sizeMatcher.replaceAll(EMPTY_STRING);
        if (sSize != null && !sSize.isEmpty()) {
            try {
                size = Integer.valueOf(sSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Font(name, style, size);
    }

    private Font parseCy2Font(String name, String style, String size) {
        return new Font(name, Integer.parseInt(style), Integer.parseInt(size));
    }

    static {
        Font[] allFonts;
        logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
        DEFAULT_FONT = new Font("SansSerif", 0, 12);
        CY2_FONT_PATTERN = Pattern.compile("(.+)-(\\d+)-(\\d+)");
        FONT_PATTERN = Pattern.compile("(\\.[bB]old)?,[a-zA-Z]+,\\d+(\\.\\d+)?");
        FONT_BOLD_PATTERN = Pattern.compile("(?i).*\\.bold,[a-zA-Z]+,.*");
        FONT_SIZE_PATTERN = Pattern.compile(".+,[^,]+,");
        HashSet<Font> fontSet = new HashSet<Font>();
        for (Font f : allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            fontSet.add(f.deriveFont(12));
        }
        FONT_RANGE = new DiscreteRange<Font>(Font.class, fontSet){

            @Override
            public boolean inRange(Font value) {
                return true;
            }
        };
    }
}

