/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.model;

import java.util.Collections;
import java.util.Set;
import org.cytoscape.view.model.Range;

public class DiscreteRange<T>
implements Range<T> {
    private final Class<T> type;
    private final Set<T> values;

    public DiscreteRange(Class<T> type, Set<T> values) {
        this.type = type;
        this.values = values;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isDiscrete() {
        return true;
    }

    public Set<T> values() {
        return Collections.unmodifiableSet(this.values);
    }

    public void addRangeValue(T newValue) {
        this.values.add(newValue);
    }

    @Override
    public boolean inRange(T value) {
        return this.values.contains(value);
    }
}

