/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public final class LayoutNode
implements Comparable<LayoutNode> {
    private static final double EPSILON = 1.0E-7;
    private double x;
    private double y;
    private double z;
    private double dispX;
    private double dispY;
    private double dispZ;
    private CyNode node;
    private CyRow row;
    private View<CyNode> nodeView;
    private int index;
    private boolean isLocked = false;
    private List<LayoutNode> neighbors = null;

    public LayoutNode(View<CyNode> nodeView, int index, CyRow row) {
        this.nodeView = nodeView;
        this.node = nodeView.getModel();
        this.row = row;
        this.index = index;
        this.x = nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
        this.y = nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        this.z = nodeView.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION);
        this.neighbors = new ArrayList<LayoutNode>();
    }

    public CyNode getNode() {
        return this.node;
    }

    public CyRow getRow() {
        return this.row;
    }

    public View<CyNode> getNodeView() {
        return this.nodeView;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setDisp(double x, double y) {
        this.dispX = x;
        this.dispY = y;
    }

    public void setDisp(double x, double y, double z) {
        this.dispX = x;
        this.dispY = y;
        this.dispZ = z;
    }

    public void addNeighbor(LayoutNode v) {
        this.neighbors.add(v);
    }

    public List<LayoutNode> getNeighbors() {
        return this.neighbors;
    }

    public int getIndex() {
        return this.index;
    }

    public void lock() {
        this.isLocked = true;
    }

    public void unLock() {
        this.isLocked = false;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void incrementDisp(double x, double y) {
        this.dispX += x;
        this.dispY += y;
    }

    public void incrementDisp(double x, double y, double z) {
        this.dispX += x;
        this.dispY += y;
        this.dispZ += z;
    }

    public void increment(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void increment(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void decrementDisp(double x, double y) {
        this.dispX -= x;
        this.dispY -= y;
    }

    public void decrementDisp(double x, double y, double z) {
        this.dispX -= x;
        this.dispY -= y;
        this.dispZ -= z;
    }

    public void decrement(double x, double y) {
        this.x -= x;
        this.y -= y;
    }

    public void decrement(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getXDisp() {
        return this.dispX;
    }

    public double getYDisp() {
        return this.dispY;
    }

    public double getZDisp() {
        return this.dispZ;
    }

    public double getWidth() {
        return this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
    }

    public double getHeight() {
        return this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_HEIGHT);
    }

    public double getDepth() {
        return this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_DEPTH);
    }

    public double distance(LayoutNode otherNode) {
        double deltaX = this.x - otherNode.getX();
        double deltaY = this.y - otherNode.getY();
        return Math.max(1.0E-7, Math.sqrt(deltaX * deltaX + deltaY * deltaY));
    }

    public double distance3D(LayoutNode otherNode) {
        double deltaX = this.x - otherNode.getX();
        double deltaY = this.y - otherNode.getY();
        double deltaZ = this.z - otherNode.getZ();
        return Math.max(1.0E-7, Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
    }

    public double distance(double uX, double uY) {
        double deltaX = this.x - uX;
        double deltaY = this.y - uY;
        return Math.max(1.0E-7, Math.sqrt(deltaX * deltaX + deltaY * deltaY));
    }

    public double distance3D(double uX, double uY, double uZ) {
        double deltaX = this.x - uX;
        double deltaY = this.y - uY;
        double deltaZ = this.z - uZ;
        return Math.max(1.0E-7, Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
    }

    public void moveToLocation() {
        if (this.isLocked) {
            this.x = this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            this.y = this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
        } else {
            this.nodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, this.x);
            this.nodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, this.y);
        }
    }

    public void moveToLocation3D() {
        if (this.isLocked) {
            this.x = this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            this.y = this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            this.z = this.nodeView.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION);
        } else {
            this.nodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, this.x);
            this.nodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, this.y);
            this.nodeView.setVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION, this.z);
        }
    }

    public String getIdentifier() {
        return this.node.getSUID().toString();
    }

    public int getDegree() {
        return this.neighbors.size();
    }

    public String toString() {
        return "Node " + this.getIdentifier() + " at " + this.printLocation();
    }

    public String printDisp() {
        return this.dispX + ", " + this.dispY;
    }

    public String printLocation() {
        return this.x + ", " + this.y;
    }

    @Override
    public int compareTo(LayoutNode nodeView) {
        return this.getIdentifier().compareTo(nodeView.getIdentifier());
    }
}

