/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.NodeViewAndLocations;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.values.Bend;
import org.cytoscape.work.undo.AbstractCyEdit;

public final class LayoutEdit
extends AbstractCyEdit {
    private final CyNetworkView view;
    private List<NodeViewAndLocations> nodeViewsAndLocations;
    private Map<View<CyEdge>, Bend> bendMap;
    private double networkScale;
    private double networkCenterX;
    private double networkCenterY;
    private double networkCenterZ;

    public LayoutEdit(String name, CyNetworkView view) {
        super(name);
        this.view = view;
        this.saveNodeViewsAndLocations();
        this.saveEdgeViews();
    }

    @Override
    public void redo() {
        this.saveAndRestore();
    }

    @Override
    public void undo() {
        this.saveAndRestore();
    }

    private void saveAndRestore() {
        List<NodeViewAndLocations> oldNodeViewsAndLocations = this.nodeViewsAndLocations;
        double oldNetworkScale = this.networkScale;
        double oldNetworkCenterX = this.networkCenterX;
        double oldNetworkCenterY = this.networkCenterY;
        double oldNetworkCenterZ = this.networkCenterZ;
        Map<View<CyEdge>, Bend> oldEdgeBends = this.bendMap;
        this.saveNodeViewsAndLocations();
        this.saveEdgeViews();
        for (NodeViewAndLocations nodeViewAndLocations : oldNodeViewsAndLocations) {
            nodeViewAndLocations.restoreLocations();
        }
        for (View view : oldEdgeBends.keySet()) {
            view.setVisualProperty(BasicVisualLexicon.EDGE_BEND, oldEdgeBends.get(view));
        }
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, oldNetworkScale);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, oldNetworkCenterX);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, oldNetworkCenterY);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION, oldNetworkCenterZ);
        this.view.updateView();
    }

    private void saveNodeViewsAndLocations() {
        this.networkScale = this.view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        this.networkCenterX = this.view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
        this.networkCenterY = this.view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
        this.networkCenterZ = this.view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION);
        Collection<View<CyNode>> nodeViews = this.view.getNodeViews();
        this.nodeViewsAndLocations = new ArrayList<NodeViewAndLocations>(nodeViews.size());
        for (View<CyNode> nodeView : nodeViews) {
            this.nodeViewsAndLocations.add(new NodeViewAndLocations(nodeView));
        }
    }

    private void saveEdgeViews() {
        this.bendMap = new WeakHashMap<View<CyEdge>, Bend>();
        Collection<View<CyEdge>> edgeViews = this.view.getEdgeViews();
        for (View<CyEdge> edgeView : edgeViews) {
            this.bendMap.put(edgeView, edgeView.getVisualProperty(BasicVisualLexicon.EDGE_BEND));
        }
    }
}

