/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.AbstractPartitionLayoutTask;
import org.cytoscape.view.layout.LayoutPartition;
import org.cytoscape.view.layout.PartitionUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.UndoSupport;

public abstract class AbstractParallelPartitionLayoutTask
extends AbstractPartitionLayoutTask {
    private final boolean singlePartition;
    private int nodesDone = 0;

    public AbstractParallelPartitionLayoutTask(String displayName, boolean singlePartition, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, String layoutAttribute, UndoSupport undo) {
        super(displayName, singlePartition, networkView, nodesToLayOut, layoutAttribute, undo);
        this.singlePartition = singlePartition;
    }

    @Override
    public void doLayout(TaskMonitor taskMonitor) {
        boolean useAllNodes;
        CyNetwork network = (CyNetwork)this.networkView.getModel();
        if (this.edgeWeighter != null) {
            this.edgeWeighter.reset();
        }
        this.taskMonitor = taskMonitor;
        long visibleNodeCount = this.networkView.getNodeViews().stream().filter(view -> view.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).count();
        boolean bl = useAllNodes = (long)this.nodesToLayOut.size() == visibleNodeCount;
        if (this.singlePartition || !useAllNodes) {
            LayoutPartition partition = new LayoutPartition(this.networkView, this.nodesToLayOut, this.edgeWeighter);
            this.partitionList = new ArrayList(1);
            this.partitionList.add(partition);
        } else {
            this.partitionList = PartitionUtil.partition(this.networkView, false, this.edgeWeighter);
        }
        this.total_nodes = network.getNodeCount();
        double screen_scale = this.networkView.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        double screen_width = this.networkView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH) / screen_scale;
        double screen_height = this.networkView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT) / screen_scale;
        int numThreads = Runtime.getRuntime().availableProcessors();
        taskMonitor.setStatusMessage("Calling layout for individual partitions");
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        double min_x = Double.MAX_VALUE;
        double max_x = Double.MIN_VALUE;
        double min_y = Double.MAX_VALUE;
        double max_y = Double.MIN_VALUE;
        for (LayoutPartition partition : this.partitionList) {
            min_x = Math.min(min_x, partition.getMinX());
            max_x = Math.max(max_x, partition.getMaxX());
            min_y = Math.min(min_y, partition.getMinY());
            max_y = Math.max(max_y, partition.getMaxY());
            threadPool.submit(new ParallelLayoutTask(partition));
        }
        threadPool.shutdown();
        try {
            boolean bl2 = threadPool.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double width = max_x - min_x;
        double height = max_y - min_y;
        double max_dimension = this.calculate_max_dimension(width, height, screen_width, screen_height, this.partitionList);
        double start_x = 0.0;
        double next_y_start = 0.0;
        double next_x_start = start_x;
        double y_max = 0.0;
        taskMonitor.setStatusMessage("Moving partitions");
        for (LayoutPartition partition : this.partitionList) {
            if (this.cancelled) break;
            partition.offset(next_x_start, next_y_start);
            next_x_start = partition.getMaxX() + this.incr;
            y_max = Math.max(y_max, partition.getMaxY());
            if (!(next_x_start > max_dimension)) continue;
            next_x_start = start_x;
            next_y_start = y_max + this.incr;
        }
    }

    class ParallelLayoutTask
    implements Runnable {
        private final LayoutPartition partition;

        public ParallelLayoutTask(LayoutPartition partition) {
            this.partition = partition;
        }

        @Override
        public void run() {
            if (AbstractParallelPartitionLayoutTask.this.cancelled) {
                return;
            }
            if (this.partition.nodeCount() > 1) {
                try {
                    this.partition.dontMove(true);
                    AbstractParallelPartitionLayoutTask.this.layoutPartition(this.partition);
                    this.partition.dontMove(false);
                }
                catch (Throwable _e) {
                    _e.printStackTrace();
                    this.partition.dontMove(false);
                    return;
                }
            }
            AbstractParallelPartitionLayoutTask.this.nodesDone += this.partition.size();
            double pDone = (double)AbstractParallelPartitionLayoutTask.this.nodesDone / AbstractParallelPartitionLayoutTask.this.total_nodes;
            AbstractParallelPartitionLayoutTask.this.taskMonitor.setProgress(pDone);
        }
    }
}

