/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.layout;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.layout.LayoutEdit;
import org.cytoscape.view.layout.LayoutPoint;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.UndoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutTask
extends AbstractTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final String displayName;
    protected static final String LAYOUT_ALGORITHM = "layoutAlgorithm";
    protected final CyNetworkView networkView;
    protected final Set<View<CyNode>> nodesToLayOut;
    protected final String layoutAttribute;
    protected final UndoSupport undo;
    protected boolean recenter = true;
    private static final Lock lock = new ReentrantLock();

    public AbstractLayoutTask(String displayName, CyNetworkView networkView, Set<View<CyNode>> nodesToLayOut, String layoutAttribute, UndoSupport undo) {
        this.networkView = networkView;
        this.displayName = displayName;
        this.undo = undo;
        if (nodesToLayOut.size() == 0) {
            this.nodesToLayOut = new HashSet<View<CyNode>>();
            for (View<CyNode> view : networkView.getNodeViews()) {
                if (!view.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE).booleanValue()) continue;
                this.nodesToLayOut.add(view);
            }
        } else {
            this.nodesToLayOut = Collections.unmodifiableSet(nodesToLayOut);
        }
        this.layoutAttribute = layoutAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run(TaskMonitor taskMonitor) {
        taskMonitor.setTitle(this.displayName);
        long start = System.currentTimeMillis();
        logger.debug("Layout Start: Algorithm = " + this.displayName);
        if (this.networkView == null) {
            return;
        }
        CyNetwork network = (CyNetwork)this.networkView.getModel();
        if (this.nodesToLayOut.size() == 0 && this.networkView.getNodeViews().size() == 0) {
            return;
        }
        if (this.undo != null) {
            this.undo.postEdit(new LayoutEdit(this.displayName, this.networkView));
        }
        LayoutPoint centroid = null;
        if (this.recenter) {
            centroid = this.computeCentroid();
        }
        this.doLayout(taskMonitor);
        if (centroid != null) {
            LayoutPoint newCentroid = this.computeCentroid();
            this.translateNodes(new LayoutPoint(centroid.getX() - newCentroid.getX(), centroid.getY() - newCentroid.getY()));
        }
        CyRow networkAttributes = network.getRow(network, "HIDDEN");
        CyTable netAttrsTable = networkAttributes.getTable();
        lock.lock();
        try {
            if (netAttrsTable.getColumn(LAYOUT_ALGORITHM) == null) {
                netAttrsTable.createColumn(LAYOUT_ALGORITHM, String.class, true);
            }
            networkAttributes.set(LAYOUT_ALGORITHM, this.displayName);
        }
        finally {
            lock.unlock();
        }
        this.networkView.fitContent();
        logger.debug("Layout finished in " + (System.currentTimeMillis() - start) + " msec.");
    }

    private void translateNodes(LayoutPoint translation) {
        Collection<View<CyNode>> views = this.nodesToLayOut.size() == 0 ? this.networkView.getNodeViews() : this.nodesToLayOut;
        for (View<CyNode> view : views) {
            double x = view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            double y = view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            double z = view.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION);
            view.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, x + translation.getX());
            view.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, y + translation.getY());
            view.setVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION, z + translation.getZ());
        }
    }

    private LayoutPoint computeCentroid() {
        Collection<View<CyNode>> views = this.nodesToLayOut.size() == 0 ? this.networkView.getNodeViews() : this.nodesToLayOut;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double total = 0.0;
        for (View<CyNode> view : views) {
            x += view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION).doubleValue();
            y += view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION).doubleValue();
            z += view.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION).doubleValue();
            total += 1.0;
        }
        if (total == 0.0) {
            return null;
        }
        return new LayoutPoint(x / total, y / total, z / total);
    }

    protected abstract void doLayout(TaskMonitor var1);
}

