/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class MessageDialogs {
    public static void showMessageDialog(JFrame parent, String title, String message) {
        MessageDialogs.showDialog(parent, message, title, "Ok", null);
    }

    public static boolean showYesNoDialog(JFrame parent, String title, String message) {
        return MessageDialogs.showDialog(parent, message, title, "Yes", "No");
    }

    public static boolean showOkCancelDialog(JFrame parent, String title, String message) {
        return MessageDialogs.showDialog(parent, message, title, "Ok", "Cancel");
    }

    private static boolean showDialog(JFrame parent, String message, String title, String okButtonText, String cancelButtonText) {
        JLabel label = new JLabel(message);
        JButton okButton = okButtonText == null ? null : new JButton(okButtonText);
        JButton cancelButton = cancelButtonText == null ? null : new JButton(cancelButtonText);
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel(okButton, cancelButton);
        JPanel bodyPanel = new JPanel(new BorderLayout());
        bodyPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bodyPanel.add((Component)label, "Center");
        bodyPanel.add((Component)buttonPanel, "South");
        JDialog dialog = new JDialog(parent);
        dialog.getContentPane().add(bodyPanel);
        boolean[] result = new boolean[]{false};
        if (okButton != null) {
            okButton.addActionListener(e -> {
                result[0] = true;
                dialog.dispose();
            });
        }
        if (cancelButton != null) {
            cancelButton.addActionListener(e -> dialog.dispose());
        }
        dialog.setTitle(title);
        dialog.setMinimumSize(new Dimension(200, 100));
        dialog.setLocationRelativeTo(parent);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
        return result[0];
    }
}

